/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.de.GermanStemmer;

public final class GermanStemFilter
extends TokenFilter {
    private GermanStemmer stemmer = new GermanStemmer();
    private Set exclusionSet = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GermanStemFilter(TokenStream in) {
        super(in);
    }

    public GermanStemFilter(TokenStream in, Set exclusionSet) {
        this(in);
        this.exclusionSet = exclusionSet;
    }

    public final Token next(Token reusableToken) throws IOException {
        String s;
        if (!$assertionsDisabled && reusableToken == null) {
            throw new AssertionError();
        }
        Token nextToken = this.input.next(reusableToken);
        if (nextToken == null) {
            return null;
        }
        String term = nextToken.term();
        if (!(this.exclusionSet != null && this.exclusionSet.contains(term) || (s = this.stemmer.stem(term)) == null || s.equals(term))) {
            nextToken.setTermBuffer(s);
        }
        return nextToken;
    }

    public void setStemmer(GermanStemmer stemmer) {
        if (stemmer != null) {
            this.stemmer = stemmer;
        }
    }

    public void setExclusionSet(Set exclusionSet) {
        this.exclusionSet = exclusionSet;
    }

    static {
        $assertionsDisabled = !GermanStemFilter.class.desiredAssertionStatus();
    }
}

