/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.web;

import java.io.IOException;
import java.net.URI;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.impl.ContextAnchor;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.core.selector.NamedContextSelector;
import org.apache.logging.log4j.spi.LoggerContextFactory;

public class JNDIContextFilter
implements Filter {
    public static final String CONTEXT_NAME = "context-name";
    public static final String CONFIG_LOCATION = "config-location";
    private ServletContext context;
    private boolean created = false;
    private String name;
    private NamedContextSelector selector = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
        this.name = filterConfig.getInitParameter(CONTEXT_NAME);
        URI configLocation = null;
        String configLocn = filterConfig.getInitParameter(CONFIG_LOCATION);
        if (configLocn != null) {
            try {
                configLocation = new URI(configLocn);
            }
            catch (Exception ex) {
                this.context.log("Unable to convert config location " + configLocn + " to a URI: " + ex.getMessage());
            }
        }
        if (this.name == null) {
            throw new UnavailableException("A context-name attribute is required");
        }
        if (this.context.getAttribute("Log4JContext") == null) {
            ContextSelector sel;
            LoggerContextFactory factory = LogManager.getFactory();
            if (factory instanceof Log4jContextFactory) {
                sel = ((Log4jContextFactory)factory).getSelector();
                if (!(sel instanceof NamedContextSelector)) {
                    return;
                }
            } else {
                return;
            }
            this.selector = (NamedContextSelector)sel;
            LoggerContext ctx = this.selector.locateContext(this.name, configLocation);
            this.context.setAttribute("Log4JContext", (Object)ctx);
            this.created = true;
            this.context.log("Created context for " + this.name + " using " + ctx.getClass().getClassLoader());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        LoggerContext ctx = (LoggerContext)this.context.getAttribute("Log4JContext");
        if (ctx != null) {
            ContextAnchor.THREAD_CONTEXT.set(ctx);
            try {
                filterChain.doFilter(servletRequest, servletResponse);
            }
            finally {
                ContextAnchor.THREAD_CONTEXT.remove();
            }
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
        LoggerContext ctx = (LoggerContext)this.context.getAttribute("Log4JContext");
        if (ctx != null && this.created) {
            this.context.log("Removing context for " + this.name);
            this.context.removeAttribute("Log4JContext");
            if (this.selector != null) {
                this.selector.removeContext(this.name);
            }
            ctx.stop();
        }
    }
}

