/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.LoggerContext;
import org.apache.logging.slf4j.SLF4JLoggingException;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.SLF4JLogger;

public class Log4JLoggerFactory
implements ILoggerFactory {
    private static final String FQCN = Log4JLoggerFactory.class.getName();
    private static final String PACKAGE = "org.slf4j";
    private final Map<LoggerContext, ConcurrentMap<String, Logger>> contextMap = new WeakHashMap<LoggerContext, ConcurrentMap<String, Logger>>();

    public Logger getLogger(String name) {
        LoggerContext context = this.getContext();
        ConcurrentMap<String, Logger> loggers = this.getLoggersMap(context);
        if (loggers.containsKey(name)) {
            return (Logger)loggers.get(name);
        }
        String key = "ROOT".equals(name) ? "" : name;
        org.apache.logging.log4j.Logger logger = context.getLogger(key);
        if (logger instanceof AbstractLogger) {
            loggers.putIfAbsent(name, (Logger)new SLF4JLogger((AbstractLogger)logger, name));
            return (Logger)loggers.get(name);
        }
        throw new SLF4JLoggingException("SLF4J Adapter requires base logging system to extend Log4J AbstractLogger");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<String, Logger> getLoggersMap(LoggerContext context) {
        Map<LoggerContext, ConcurrentMap<String, Logger>> map = this.contextMap;
        synchronized (map) {
            ConcurrentMap<String, Logger> map2 = this.contextMap.get(context);
            if (map2 == null) {
                map2 = new ConcurrentHashMap<String, Logger>();
                this.contextMap.put(context, map2);
            }
            return map2;
        }
    }

    private LoggerContext getContext() {
        Throwable t = new Throwable();
        boolean next = false;
        boolean pkg = false;
        String fqcn = LoggerFactory.class.getName();
        for (StackTraceElement element : t.getStackTrace()) {
            if (FQCN.equals(element.getClassName())) {
                next = true;
                continue;
            }
            if (next && element.getClassName().startsWith(PACKAGE)) {
                fqcn = element.getClassName();
                pkg = true;
                continue;
            }
            if (pkg) break;
        }
        return PrivateManager.getContext(fqcn);
    }

    private static class PrivateManager
    extends LogManager {
        private static final String FQCN = LoggerFactory.class.getName();

        private PrivateManager() {
        }

        public static LoggerContext getContext() {
            return PrivateManager.getContext((String)FQCN, (boolean)false);
        }

        public static LoggerContext getContext(String fqcn) {
            return PrivateManager.getContext((String)fqcn, (boolean)false);
        }

        public static org.apache.logging.log4j.Logger getLogger(String name) {
            return PrivateManager.getLogger((String)FQCN, (String)name);
        }
    }
}

