/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;

final class LoggerResolver
implements EventResolver {
    private static final EventResolver NAME_RESOLVER = (logEvent, jsonWriter) -> {
        String loggerName = logEvent.getLoggerName();
        jsonWriter.writeString(loggerName);
    };
    private static final EventResolver FQCN_RESOLVER = (logEvent, jsonWriter) -> {
        String loggerFqcn = logEvent.getLoggerFqcn();
        jsonWriter.writeString(loggerFqcn);
    };
    private final EventResolver internalResolver;

    LoggerResolver(TemplateResolverConfig config) {
        this.internalResolver = LoggerResolver.createInternalResolver(config);
    }

    private static EventResolver createInternalResolver(TemplateResolverConfig config) {
        String fieldName;
        switch (fieldName = config.getString("field")) {
            case "name": {
                return NAME_RESOLVER;
            }
            case "fqcn": {
                return FQCN_RESOLVER;
            }
        }
        throw new IllegalArgumentException("unknown field: " + config);
    }

    static String getName() {
        return "logger";
    }

    @Override
    public void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
        this.internalResolver.resolve(logEvent, jsonWriter);
    }
}

