/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docgen.processor;

import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.docgen.processor.ElementImportsFactory;
import org.jspecify.annotations.Nullable;

final class ElementImports
extends TreeMap<String, String> {
    private static final ElementImports EMPTY = new ElementImports();
    private static final long serialVersionUID = 0L;

    private ElementImports() {
    }

    private ElementImports(Map<String, String> imports) {
        super(imports);
    }

    static ElementImportsFactory factory(Trees trees) {
        return element -> {
            ImportCollectingTreeScanner scanner = new ImportCollectingTreeScanner();
            @Nullable TreePath treePath = trees.getPath(element);
            if (treePath == null) {
                return EMPTY;
            }
            scanner.scan(treePath.getCompilationUnit(), null);
            return new ElementImports(scanner.imports);
        };
    }

    private static final class ImportCollectingTreeScanner
    extends TreeScanner<Object, Trees> {
        private final Map<String, String> imports = new HashMap<String, String>();

        private ImportCollectingTreeScanner() {
        }

        @Override
        public Object visitImport(ImportTree importTree, Trees trees) {
            Tree qualifiedIdentifier = importTree.getQualifiedIdentifier();
            String qualifiedClassName = qualifiedIdentifier.toString();
            String simpleClassName = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(46) + 1);
            this.imports.put(simpleClassName, qualifiedClassName);
            return super.visitImport(importTree, trees);
        }
    }
}

