/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docgen.generator.internal;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.apache.logging.log4j.docgen.AbstractType;
import org.apache.logging.log4j.docgen.PluginSet;
import org.apache.logging.log4j.docgen.PluginType;
import org.apache.logging.log4j.docgen.generator.internal.ArtifactSourcedType;
import org.jspecify.annotations.Nullable;

public final class TypeLookup
extends TreeMap<String, ArtifactSourcedType> {
    private static final long serialVersionUID = 1L;

    public static TypeLookup of(Iterable<? extends PluginSet> pluginSets, Predicate<String> classNameFilter) {
        return new TypeLookup(pluginSets, classNameFilter);
    }

    private TypeLookup(Iterable<? extends PluginSet> pluginSets, Predicate<String> classNameFilter) {
        this.mergeDescriptors(pluginSets);
        this.populateTypeHierarchy(pluginSets);
        this.filterTypes(classNameFilter);
    }

    private void mergeDescriptors(Iterable<? extends PluginSet> pluginSets) {
        pluginSets.forEach((? super T pluginSet) -> {
            pluginSet.getScalars().forEach((? super T scalar) -> {
                ArtifactSourcedType sourcedType = ArtifactSourcedType.ofPluginSet(pluginSet, scalar);
                this.putIfAbsent(scalar.getClassName(), sourcedType);
            });
            pluginSet.getAbstractTypes().forEach((? super T abstractType) -> {
                ArtifactSourcedType sourcedType = ArtifactSourcedType.ofPluginSet(pluginSet, abstractType);
                this.putIfAbsent(abstractType.getClassName(), sourcedType);
            });
            pluginSet.getPlugins().forEach((? super T pluginType) -> {
                ArtifactSourcedType sourcedType = ArtifactSourcedType.ofPluginSet(pluginSet, pluginType);
                this.putIfAbsent(pluginType.getClassName(), sourcedType);
            });
        });
    }

    private void populateTypeHierarchy(Iterable<? extends PluginSet> pluginSets) {
        pluginSets.forEach((? super T pluginSet) -> {
            Set<PluginType> pluginTypes = pluginSet.getPlugins();
            pluginTypes.forEach((? super T plugin) -> {
                Set<String> superTypeClassNames = plugin.getSupertypes();
                superTypeClassNames.forEach((? super T superTypeClassName) -> {
                    AbstractType sourcedSuperType = this.getOrPutAbstractType((String)superTypeClassName, (PluginSet)pluginSet);
                    sourcedSuperType.addImplementation(plugin.getClassName());
                });
            });
        });
    }

    private @Nullable AbstractType getOrPutAbstractType(String className, PluginSet pluginSet) {
        @Nullable ArtifactSourcedType foundSourcedType = (ArtifactSourcedType)this.get(className);
        if (foundSourcedType != null) {
            return (AbstractType)foundSourcedType.type;
        }
        AbstractType type = new AbstractType();
        type.setClassName(className);
        ArtifactSourcedType sourcedType = ArtifactSourcedType.ofPluginSet(pluginSet, type);
        this.put(className, sourcedType);
        return type;
    }

    private void filterTypes(Predicate<String> classNameMatcher) {
        Iterator classNameIterator = this.keySet().iterator();
        while (classNameIterator.hasNext()) {
            String className = (String)classNameIterator.next();
            boolean matching = classNameMatcher.test(className);
            if (matching) continue;
            classNameIterator.remove();
        }
    }
}

