/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog.releaser;

import java.util.Objects;

final class VersionUtils {
    private static final String VERSION_PATTERN = "^\\d+\\.\\d+\\.\\d+(-SNAPSHOT)?$";

    private VersionUtils() {
    }

    static String requireSemanticVersioning(String version, String fieldName) {
        Objects.requireNonNull(version, fieldName);
        if (!version.matches(VERSION_PATTERN)) {
            String message = String.format("provided version in `%s` does not match the expected `<major>.<minor>.<patch>[-SNAPSHOT]` pattern: `%s`", fieldName, version);
            throw new IllegalArgumentException(message);
        }
        return version;
    }

    static int versionMajor(String version) {
        return Integer.parseInt(version.split("\\.", 2)[0]);
    }
}

