/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog.util;

public final class VersionUtils {
    public static final String VERSION_PATTERN = "^\\d+\\.\\d+\\.\\d+(-SNAPSHOT)?$";

    private VersionUtils() {
    }

    public static void requireSemanticVersioning(String version, String name) {
        if (!version.matches(VERSION_PATTERN)) {
            String message = String.format("provided version in `%s` does not match the expected `<major>.<minor>.<patch>[-SNAPSHOT]` pattern: `%s`", name, version);
            throw new IllegalArgumentException(message);
        }
    }

    public static int versionMajor(String version) {
        return Integer.parseInt(version.split("\\.", 2)[0]);
    }
}

