/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog.util;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.changelog.util.StringUtils;

public final class PropertyUtils {
    private PropertyUtils() {
    }

    public static Path requireNonBlankPathProperty(String key) {
        String value = PropertyUtils.requireNonBlankStringProperty(key);
        try {
            return Paths.get(value, new String[0]);
        }
        catch (InvalidPathException error) {
            String message = String.format("system property `%s` doesn't contain a valid path: `%s`", key, value);
            throw new IllegalArgumentException(message, error);
        }
    }

    public static int requireNonBlankIntProperty(String key) {
        String value = PropertyUtils.requireNonBlankStringProperty(key);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException error) {
            String message = String.format("system property `%s` doesn't contain a valid integer: `%s`", key, value);
            throw new IllegalArgumentException(message, error);
        }
    }

    public static String requireNonBlankStringProperty(String key) {
        String value = System.getProperty(key);
        if (StringUtils.isBlank(value)) {
            String message = String.format("blank system property: `%s`", key);
            throw new IllegalArgumentException(message);
        }
        return value;
    }
}

