/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog.releaser;

import java.nio.file.Path;
import java.time.LocalDate;
import java.util.Objects;
import org.apache.logging.log4j.changelog.util.PropertyUtils;
import org.apache.logging.log4j.changelog.util.VersionUtils;

public final class ChangelogReleaserArgs {
    public static final String CHANGELOG_DIRECTORY_PROPERTY_NAME = "log4j.changelog.directory";
    public static final String RELEASE_VERSION_PROPERTY_NAME = "log4j.changelog.releaseVersion";
    final Path changelogDirectory;
    final String releaseVersion;
    final LocalDate releaseDate;

    public ChangelogReleaserArgs(Path changelogDirectory, String releaseVersion, LocalDate releaseDate) {
        Objects.requireNonNull(changelogDirectory, "changelogDirectory");
        Objects.requireNonNull(releaseVersion, "releaseVersion");
        VersionUtils.requireSemanticVersioning(releaseVersion, RELEASE_VERSION_PROPERTY_NAME);
        Objects.requireNonNull(releaseDate, "releaseDate");
        this.changelogDirectory = changelogDirectory;
        this.releaseVersion = releaseVersion;
        this.releaseDate = releaseDate;
    }

    static ChangelogReleaserArgs fromSystemProperties() {
        Path changelogDirectory = PropertyUtils.requireNonBlankPathProperty(CHANGELOG_DIRECTORY_PROPERTY_NAME);
        String releaseVersion = PropertyUtils.requireNonBlankStringProperty(RELEASE_VERSION_PROPERTY_NAME);
        LocalDate releaseDate = LocalDate.now();
        return new ChangelogReleaserArgs(changelogDirectory, releaseVersion, releaseDate);
    }
}

