/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog.releaser;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.apache.logging.log4j.changelog.ChangelogFiles;
import org.apache.logging.log4j.changelog.ChangelogRelease;
import org.apache.logging.log4j.changelog.releaser.ChangelogReleaserArgs;
import org.apache.logging.log4j.changelog.util.FileUtils;
import org.apache.logging.log4j.changelog.util.VersionUtils;

public final class ChangelogReleaser {
    private ChangelogReleaser() {
    }

    public static void main(String[] mainArgs) {
        ChangelogReleaserArgs args = ChangelogReleaserArgs.fromSystemProperties();
        ChangelogReleaser.performRelease(args);
    }

    public static void performRelease(ChangelogReleaserArgs args) {
        String releaseDate = DateTimeFormatter.ISO_DATE.format(args.releaseDate != null ? args.releaseDate : LocalDate.now());
        int releaseVersionMajor = VersionUtils.versionMajor(args.releaseVersion);
        System.out.format("using `%s` for the release date%n", releaseDate);
        try {
            Path unreleasedDirectory = ChangelogFiles.unreleasedDirectory(args.changelogDirectory, releaseVersionMajor);
            Path releaseDirectory = ChangelogFiles.releaseDirectory(args.changelogDirectory, args.releaseVersion);
            ChangelogReleaser.populateChangelogEntryFiles(unreleasedDirectory, releaseDirectory);
            ChangelogReleaser.populateReleaseXmlFiles(releaseDate, args.releaseVersion, releaseDirectory);
            ChangelogReleaser.populateReleaseChangelogTemplateFile(unreleasedDirectory, releaseDirectory);
        }
        catch (IOException error) {
            throw new UncheckedIOException(error);
        }
    }

    private static void populateChangelogEntryFiles(Path unreleasedDirectory, Path releaseDirectory) throws IOException {
        if (Files.exists(releaseDirectory, new LinkOption[0])) {
            System.out.format("release directory `%s` already exists, only moving the changelog entry files from `%s`%n", releaseDirectory, unreleasedDirectory);
            ChangelogReleaser.moveUnreleasedChangelogEntryFiles(unreleasedDirectory, releaseDirectory);
        } else {
            System.out.format("release directory `%s` doesn't exist, simply renaming the unreleased directory `%s`%n", releaseDirectory, unreleasedDirectory);
            ChangelogReleaser.moveUnreleasedDirectory(unreleasedDirectory, releaseDirectory);
        }
    }

    private static void moveUnreleasedChangelogEntryFiles(Path unreleasedDirectory, Path releaseDirectory) {
        FileUtils.findAdjacentFiles(unreleasedDirectory, true, paths -> {
            paths.forEach(unreleasedChangelogEntryFile -> {
                String fileName = unreleasedChangelogEntryFile.getFileName().toString();
                Path releasedChangelogEntryFile = releaseDirectory.resolve(fileName);
                System.out.format("moving changelog entry file `%s` to `%s`%n", unreleasedChangelogEntryFile, releasedChangelogEntryFile);
                try {
                    Files.move(unreleasedChangelogEntryFile, releasedChangelogEntryFile, new CopyOption[0]);
                }
                catch (IOException error) {
                    throw new UncheckedIOException(error);
                }
            });
            return 1;
        });
    }

    private static void moveUnreleasedDirectory(Path unreleasedDirectory, Path releaseDirectory) throws IOException {
        if (!Files.exists(unreleasedDirectory, new LinkOption[0])) {
            String message = String.format("`%s` does not exist! A release without any changelogs don't make sense!", unreleasedDirectory);
            throw new IllegalStateException(message);
        }
        System.out.format("moving changelog directory `%s` to `%s`%n", unreleasedDirectory, releaseDirectory);
        Files.move(unreleasedDirectory, releaseDirectory, new CopyOption[0]);
        Files.createDirectories(unreleasedDirectory, new FileAttribute[0]);
    }

    private static void populateReleaseXmlFiles(String releaseDate, String releaseVersion, Path releaseDirectory) throws IOException {
        Path releaseXmlFile = ChangelogFiles.releaseXmlFile(releaseDirectory);
        System.out.format("writing release information to `%s`%n", releaseXmlFile);
        ChangelogRelease changelogRelease = new ChangelogRelease(releaseVersion, releaseDate);
        Files.deleteIfExists(releaseXmlFile);
        changelogRelease.writeToXmlFile(releaseXmlFile);
    }

    private static void populateReleaseChangelogTemplateFile(Path unreleasedDirectory, Path releaseDirectory) throws IOException {
        Path targetFile = ChangelogFiles.releaseChangelogTemplateFile(releaseDirectory);
        if (Files.exists(targetFile, new LinkOption[0])) {
            System.out.format("keeping the existing changelog template file: `%s`%n", targetFile);
        } else {
            Path sourceFile = ChangelogFiles.releaseChangelogTemplateFile(unreleasedDirectory);
            System.out.format("moving the changelog template file `%s` to `%s`%n", sourceFile, targetFile);
            Files.move(sourceFile, targetFile, new CopyOption[0]);
        }
    }
}

