/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog.importer;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.changelog.util.StringUtils;
import org.apache.logging.log4j.changelog.util.XmlReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class MavenChanges {
    final List<Release> releases;

    private MavenChanges(List<Release> releases) {
        this.releases = releases;
    }

    static MavenChanges readFromFile(Path file) {
        Element documentElement = XmlReader.readXmlFileRootElement(file, "document");
        Element bodyElement = XmlReader.requireChildElementMatchingName(documentElement, "body");
        ArrayList<Release> releases = new ArrayList<Release>();
        NodeList releaseNodes = bodyElement.getChildNodes();
        int releaseNodeCount = releaseNodes.getLength();
        for (int releaseNodeIndex = 0; releaseNodeIndex < releaseNodeCount; ++releaseNodeIndex) {
            Node releaseNode = releaseNodes.item(releaseNodeIndex);
            if (!"release".equals(releaseNode.getNodeName()) || 1 != releaseNode.getNodeType()) continue;
            Element releaseElement = (Element)releaseNode;
            Release release = Release.fromElement(releaseElement);
            releases.add(release);
        }
        return new MavenChanges(releases);
    }

    static final class Action {
        @Nullable
        final String issue;
        final Type type;
        final String dev;
        @Nullable
        final String dueTo;
        final String description;

        private Action(@Nullable String issue, Type type, String dev, @Nullable String dueTo, String description) {
            this.issue = issue;
            this.type = type;
            this.dev = dev;
            this.dueTo = dueTo;
            this.description = description;
        }

        private static Action fromElement(Element element) {
            String description;
            Type type;
            String issue = StringUtils.trimNullable(element.getAttribute("issue"));
            String issuePattern = "^LOG4J2-[0-9]+$";
            if (StringUtils.isBlank(issue)) {
                issue = null;
            } else if (!issue.matches("^LOG4J2-[0-9]+$")) {
                throw XmlReader.failureAtXmlNode(element, "`issue` doesn't match with the `%s` pattern: `%s`", "^LOG4J2-[0-9]+$", issue);
            }
            String typeString = StringUtils.trimNullable(element.getAttribute("type"));
            if (StringUtils.isBlank(typeString)) {
                type = Type.UPDATE;
            } else {
                try {
                    type = Type.valueOf(typeString.toUpperCase(Locale.US));
                }
                catch (IllegalArgumentException error) {
                    throw XmlReader.failureAtXmlNode(error, element, "invalid type: `%s`", typeString);
                }
            }
            String dev = StringUtils.trimNullable(element.getAttribute("dev"));
            if (StringUtils.isBlank(dev)) {
                throw XmlReader.failureAtXmlNode(element, "blank attribute: `dev`", new Object[0]);
            }
            String dueTo = StringUtils.trimNullable(element.getAttribute("due-to"));
            if (StringUtils.isBlank(dueTo)) {
                dueTo = null;
            }
            if (StringUtils.isBlank(description = StringUtils.trimNullable(element.getTextContent()))) {
                throw XmlReader.failureAtXmlNode(element, "blank `description`", new Object[0]);
            }
            return new Action(issue, type, dev, dueTo, description);
        }

        public String toString() {
            return this.issue != null ? this.issue : "unknown";
        }

        static enum Type {
            ADD,
            FIX,
            UPDATE,
            REMOVE;

        }
    }

    static final class Release {
        final String version;
        final String date;
        final List<Action> actions;

        private Release(String version, String date, List<Action> actions) {
            this.version = version;
            this.date = date;
            this.actions = actions;
        }

        private static Release fromElement(Element element) {
            String version = StringUtils.trimNullable(element.getAttribute("version"));
            if (StringUtils.isBlank(version)) {
                throw XmlReader.failureAtXmlNode(element, "blank attribute: `version`", new Object[0]);
            }
            String date = StringUtils.trimNullable(element.getAttribute("date"));
            String datePattern = "^(TBD|[0-9]{4}-[0-9]{2}-[0-9]{2})$";
            if (!date.matches("^(TBD|[0-9]{4}-[0-9]{2}-[0-9]{2})$")) {
                throw XmlReader.failureAtXmlNode(element, "`date` doesn't match with the `%s` pattern: `%s`", "^(TBD|[0-9]{4}-[0-9]{2}-[0-9]{2})$", date);
            }
            ArrayList<Action> actions = new ArrayList<Action>();
            NodeList actionNodes = element.getChildNodes();
            int actionNodeCount = actionNodes.getLength();
            for (int actionNodeIndex = 0; actionNodeIndex < actionNodeCount; ++actionNodeIndex) {
                Node actionNode = actionNodes.item(actionNodeIndex);
                if (!"action".equals(actionNode.getNodeName()) || 1 != actionNode.getNodeType()) continue;
                Element actionElement = (Element)actionNode;
                Action action = Action.fromElement(actionElement);
                actions.add(action);
            }
            return new Release(version, date, actions);
        }

        public String toString() {
            return this.version + " @ " + this.date;
        }
    }
}

