/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog.exporter;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.changelog.util.CharsetUtils;

final class FreeMarkerUtils {
    private FreeMarkerUtils() {
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    private static Configuration createConfiguration(Path templateDirectory) {
        Version configurationVersion = Configuration.VERSION_2_3_29;
        Configuration configuration = new Configuration(configurationVersion);
        configuration.setDefaultEncoding(CharsetUtils.CHARSET_NAME);
        configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        try {
            configuration.setTemplateLoader((TemplateLoader)new FileTemplateLoader(templateDirectory.toFile()));
        }
        catch (IOException error) {
            throw new UncheckedIOException(error);
        }
        DefaultObjectWrapperBuilder objectWrapperBuilder = new DefaultObjectWrapperBuilder(configurationVersion);
        objectWrapperBuilder.setExposeFields(true);
        DefaultObjectWrapper objectWrapper = objectWrapperBuilder.build();
        configuration.setObjectWrapper((ObjectWrapper)objectWrapper);
        configuration.setLogTemplateExceptions(false);
        configuration.setWrapUncheckedExceptions(true);
        configuration.setFallbackOnNullLoopVariable(false);
        return configuration;
    }

    @SuppressFBWarnings(value={"TEMPLATE_INJECTION_FREEMARKER"})
    static void render(Path templateDirectory, String templateName, Object templateData, Path outputFile) {
        try {
            Configuration configuration = FreeMarkerUtils.createConfiguration(templateDirectory);
            Template template = configuration.getTemplate(templateName);
            Path outputFileParent = outputFile.getParent();
            if (outputFileParent != null) {
                Files.createDirectories(outputFileParent, new FileAttribute[0]);
            }
            try (BufferedWriter outputFileWriter = Files.newBufferedWriter(outputFile, CharsetUtils.CHARSET, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                template.process(templateData, (Writer)outputFileWriter);
            }
        }
        catch (Exception error) {
            String message = String.format("failed rendering template `%s` to file `%s`", templateName, outputFile);
            throw new RuntimeException(message, error);
        }
    }
}

