/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.internal.recycler;

import aQute.bnd.annotation.spi.ServiceProvider;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.internal.recycler.ArrayQueue;
import org.apache.logging.log4j.spi.LoggingSystemProperty;
import org.apache.logging.log4j.spi.recycler.AbstractRecycler;
import org.apache.logging.log4j.spi.recycler.Recycler;
import org.apache.logging.log4j.spi.recycler.RecyclerFactory;
import org.apache.logging.log4j.spi.recycler.RecyclerFactoryProvider;
import org.apache.logging.log4j.util.PropertyEnvironment;

@ServiceProvider(value=RecyclerFactoryProvider.class)
public final class ThreadLocalRecyclerFactoryProvider
implements RecyclerFactoryProvider {
    @Override
    public int getOrder() {
        return 700;
    }

    @Override
    public String getName() {
        return "threadLocal";
    }

    @Override
    @Nullable
    public RecyclerFactory createForEnvironment(PropertyEnvironment environment) {
        Objects.requireNonNull(environment, "environment");
        boolean threadLocalEnabled = environment.getBooleanProperty(LoggingSystemProperty.THREAD_LOCALS_ENABLE, true);
        if (!threadLocalEnabled) {
            return null;
        }
        int capacity = environment.getIntegerProperty(LoggingSystemProperty.RECYCLER_CAPACITY, Recycler.DEFAULT_CAPACITY);
        if (capacity < 1) {
            throw new IllegalArgumentException("was expecting a `capacity` greater than 1, found: " + capacity);
        }
        return new ThreadLocalRecyclerFactory(capacity);
    }

    static final class ThreadLocalRecyclerFactory
    implements RecyclerFactory {
        final int capacity;

        private ThreadLocalRecyclerFactory(int capacity) {
            this.capacity = capacity;
        }

        @Override
        public <V> Recycler<V> create(Supplier<V> supplier, Consumer<V> cleaner) {
            Objects.requireNonNull(supplier, "supplier");
            Objects.requireNonNull(cleaner, "cleaner");
            return new ThreadLocalRecycler<V>(supplier, cleaner, this.capacity);
        }

        static final class ThreadLocalRecycler<V>
        extends AbstractRecycler<V> {
            private final Consumer<V> cleaner;
            final ThreadLocal<Queue<V>> queueRef = ThreadLocal.withInitial(() -> new ArrayQueue(capacity));

            private ThreadLocalRecycler(Supplier<V> supplier, Consumer<V> cleaner, int capacity) {
                super(supplier);
                this.cleaner = cleaner;
            }

            @Override
            public V acquire() {
                Queue<V> queue = this.queueRef.get();
                V value = queue.poll();
                return value != null ? value : this.createInstance();
            }

            @Override
            public void release(V value) {
                Objects.requireNonNull(value, "value");
                this.cleaner.accept(value);
                Queue<V> queue = this.queueRef.get();
                queue.offer(value);
            }
        }
    }
}

