/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.ThreadContextUtilityClass;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ThreadContextInheritanceTest {
    @BeforeClass
    public static void setupClass() {
        System.setProperty("isThreadContextMapInheritable", "true");
        ThreadContext.init();
    }

    @AfterClass
    public static void tearDownClass() {
        System.clearProperty("isThreadContextMapInheritable");
        ThreadContext.init();
    }

    @Test
    public void testPush() {
        ThreadContext.push((String)"Hello");
        ThreadContext.push((String)"{} is {}", (Object[])new Object[]{ThreadContextInheritanceTest.class.getSimpleName(), "running"});
        Assert.assertEquals((String)"Incorrect parameterized stack value", (Object)ThreadContext.pop(), (Object)"ThreadContextInheritanceTest is running");
        Assert.assertEquals((String)"Incorrect simple stack value", (Object)ThreadContext.pop(), (Object)"Hello");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInheritanceSwitchedOn() throws Exception {
        System.setProperty("isThreadContextMapInheritable", "true");
        try {
            ThreadContext.clearMap();
            ThreadContext.put((String)"Greeting", (String)"Hello");
            StringBuilder sb = new StringBuilder();
            TestThread thread = new TestThread(sb);
            thread.start();
            thread.join();
            String str = sb.toString();
            Assert.assertTrue((String)("Unexpected ThreadContext value. Expected Hello. Actual " + str), (boolean)"Hello".equals(str));
            sb = new StringBuilder();
            thread = new TestThread(sb);
            thread.start();
            thread.join();
            str = sb.toString();
            Assert.assertTrue((String)("Unexpected ThreadContext value. Expected Hello. Actual " + str), (boolean)"Hello".equals(str));
        }
        finally {
            System.clearProperty("isThreadContextMapInheritable");
        }
    }

    @Test
    public void perfTest() throws Exception {
        ThreadContextUtilityClass.perfTest();
    }

    @Test
    public void testGetContextReturnsEmptyMapIfEmpty() {
        ThreadContextUtilityClass.testGetContextReturnsEmptyMapIfEmpty();
    }

    @Test
    public void testGetContextReturnsMutableCopy() {
        ThreadContextUtilityClass.testGetContextReturnsMutableCopy();
    }

    @Test
    public void testGetImmutableContextReturnsEmptyMapIfEmpty() {
        ThreadContextUtilityClass.testGetImmutableContextReturnsEmptyMapIfEmpty();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetImmutableContextReturnsImmutableMapIfNonEmpty() {
        ThreadContextUtilityClass.testGetImmutableContextReturnsImmutableMapIfNonEmpty();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetImmutableContextReturnsImmutableMapIfEmpty() {
        ThreadContextUtilityClass.testGetImmutableContextReturnsImmutableMapIfEmpty();
    }

    @Test
    public void testGetImmutableStackReturnsEmptyStackIfEmpty() {
        ThreadContextUtilityClass.testGetImmutableStackReturnsEmptyStackIfEmpty();
    }

    @Test
    public void testPut() {
        ThreadContextUtilityClass.testPut();
    }

    @Test
    public void testRemove() {
        ThreadContext.clearMap();
        Assert.assertNull((Object)ThreadContext.get((String)"testKey"));
        ThreadContext.put((String)"testKey", (String)"testValue");
        Assert.assertEquals((Object)"testValue", (Object)ThreadContext.get((String)"testKey"));
        ThreadContext.remove((String)"testKey");
        Assert.assertNull((Object)ThreadContext.get((String)"testKey"));
        Assert.assertTrue((boolean)ThreadContext.isEmpty());
    }

    @Test
    public void testContainsKey() {
        ThreadContext.clearMap();
        Assert.assertFalse((boolean)ThreadContext.containsKey((String)"testKey"));
        ThreadContext.put((String)"testKey", (String)"testValue");
        Assert.assertTrue((boolean)ThreadContext.containsKey((String)"testKey"));
        ThreadContext.remove((String)"testKey");
        Assert.assertFalse((boolean)ThreadContext.containsKey((String)"testKey"));
    }

    private class TestThread
    extends Thread {
        private final StringBuilder sb;

        public TestThread(StringBuilder sb) {
            this.sb = sb;
        }

        @Override
        public void run() {
            String greeting = ThreadContext.get((String)"Greeting");
            if (greeting == null) {
                this.sb.append("null");
            } else {
                this.sb.append(greeting);
            }
            ThreadContext.clearMap();
        }
    }
}

