/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.spi.AbstractLogger;

public class TestLogger
extends AbstractLogger {
    private static final long serialVersionUID = 1L;
    private final List<String> list = new ArrayList<String>();

    public TestLogger() {
    }

    public TestLogger(String name, MessageFactory messageFactory) {
        super(name, messageFactory);
    }

    public TestLogger(String name) {
        super(name);
    }

    public List<String> getEntries() {
        return this.list;
    }

    public void logMessage(String fqcn, Level level, Marker marker, Message msg, Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        if (marker != null) {
            sb.append(marker);
        }
        sb.append(' ');
        sb.append(level.toString());
        sb.append(' ');
        sb.append(msg.getFormattedMessage());
        Map mdc = ThreadContext.getContext();
        if (mdc.size() > 0) {
            sb.append(' ');
            sb.append(mdc.toString());
            sb.append(' ');
        }
        Object[] params = msg.getParameters();
        Throwable t = throwable == null && params != null && params.length > 0 && params[params.length - 1] instanceof Throwable ? (Throwable)params[params.length - 1] : throwable;
        if (t != null) {
            sb.append(' ');
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(baos));
            sb.append(baos.toString());
        }
        this.list.add(sb.toString());
    }

    public boolean isEnabled(Level level, Marker marker, String msg) {
        return true;
    }

    public boolean isEnabled(Level level, Marker marker, String msg, Throwable t) {
        return true;
    }

    public boolean isEnabled(Level level, Marker marker, String msg, Object ... p1) {
        return true;
    }

    public boolean isEnabled(Level level, Marker marker, Object msg, Throwable t) {
        return true;
    }

    public boolean isEnabled(Level level, Marker marker, Message msg, Throwable t) {
        return true;
    }

    public Level getLevel() {
        return Level.ALL;
    }
}

