/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.MessageFormatMessage;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.StringFormattedMessage;
import org.apache.logging.log4j.util.Timer;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceAccessMode;
import org.junit.jupiter.api.parallel.ResourceLock;

@Tag(value="performance")
@ResourceLock(value="java.util.Locale.default", mode=ResourceAccessMode.READ)
public class MessageFormatsPerfTest {
    private static final int LOOP_CNT = 500;
    String[] array = new String[500];
    private static long stringTime = 0L;
    private static long paramTime = 0L;
    private static long msgFormatTime = 0L;
    private static long formattedTime = 0L;

    @AfterAll
    public static void after() {
        if (stringTime > paramTime) {
            System.out.println(String.format("Parameterized is %1$.2f times faster than StringFormat.", Float.valueOf((float)stringTime / (float)paramTime)));
        } else if (stringTime < paramTime) {
            System.out.println(String.format("Parameterized is %1$.2f times slower than StringFormat.", Float.valueOf((float)paramTime / (float)stringTime)));
        } else {
            System.out.println("The speed of Parameterized and StringFormat are the same");
        }
        if (msgFormatTime > paramTime) {
            System.out.println(String.format("Parameterized is %1$.2f times faster than MessageFormat.", Float.valueOf((float)msgFormatTime / (float)paramTime)));
        } else if (msgFormatTime < paramTime) {
            System.out.println(String.format("Parameterized is %1$.2f times slower than MessageFormat.", Float.valueOf((float)paramTime / (float)msgFormatTime)));
        } else {
            System.out.println("The speed of Parameterized and MessageFormat are the same");
        }
        if (formattedTime > paramTime) {
            System.out.println(String.format("Parameterized is %1$.2f times faster than Formatted.", Float.valueOf((float)formattedTime / (float)paramTime)));
        } else if (formattedTime < paramTime) {
            System.out.println(String.format("Parameterized is %1$.2f times slower than Formatted.", Float.valueOf((float)paramTime / (float)formattedTime)));
        } else {
            System.out.println("The speed of Parameterized and Formatted are the same");
        }
    }

    @Test
    public void testStringPerf() {
        String testMsg = "Test message %1s %2s";
        Timer timer = new Timer("StringFormat", 500);
        timer.start();
        for (int i = 0; i < 500; ++i) {
            StringFormattedMessage msg = new StringFormattedMessage("Test message %1s %2s", new Object[]{"Apache", "Log4j"});
            this.array[i] = msg.getFormattedMessage();
        }
        timer.stop();
        stringTime = timer.getElapsedNanoTime();
        System.out.println(timer.toString());
    }

    @Test
    public void testMessageFormatPerf() {
        String testMsg = "Test message {0} {1}";
        Timer timer = new Timer("MessageFormat", 500);
        timer.start();
        for (int i = 0; i < 500; ++i) {
            MessageFormatMessage msg = new MessageFormatMessage("Test message {0} {1}", new Object[]{"Apache", "Log4j"});
            this.array[i] = msg.getFormattedMessage();
        }
        timer.stop();
        msgFormatTime = timer.getElapsedNanoTime();
        System.out.println(timer.toString());
    }

    @Test
    public void testParameterizedPerf() {
        String testMsg = "Test message {} {}";
        Timer timer = new Timer("Parameterized", 500);
        timer.start();
        for (int i = 0; i < 500; ++i) {
            ParameterizedMessage msg = new ParameterizedMessage("Test message {} {}", (Object)"Apache", (Object)"Log4j");
            this.array[i] = msg.getFormattedMessage();
        }
        timer.stop();
        paramTime = timer.getElapsedNanoTime();
        System.out.println(timer.toString());
    }

    @Test
    public void testFormattedParameterizedPerf() {
        String testMsg = "Test message {} {}";
        Timer timer = new Timer("FormattedParameterized", 500);
        timer.start();
        for (int i = 0; i < 500; ++i) {
            FormattedMessage msg = new FormattedMessage("Test message {} {}", (Object)"Apache", (Object)"Log4j");
            this.array[i] = msg.getFormattedMessage();
        }
        timer.stop();
        formattedTime = timer.getElapsedNanoTime();
        System.out.println(timer.toString());
    }
}

