/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.TestLogger;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.JsonMessage;
import org.apache.logging.log4j.message.LocalizedMessage;
import org.apache.logging.log4j.message.MessageFormatMessage;
import org.apache.logging.log4j.message.ObjectArrayMessage;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.message.StringFormattedMessage;
import org.apache.logging.log4j.message.ThreadDumpMessage;
import org.apache.logging.log4j.util.Supplier;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.junit.jupiter.api.parallel.ResourceLocks;

@ResourceLocks(value={@ResourceLock(value="java.util.Locale.default"), @ResourceLock(value="log4j2.TestLogger")})
public class LoggerSupplierTest {
    private final TestLogger logger = (TestLogger)LogManager.getLogger((String)"LoggerTest");
    private final List<String> results = this.logger.getEntries();
    Locale defaultLocale;

    @Test
    public void flowTracing_SupplierOfFormattedMessage() {
        this.logger.traceEntry(new Supplier[]{() -> new FormattedMessage("int foo={}", (Object)1234567890)});
        Assertions.assertThat(this.results).hasSize(1);
        String entry = this.results.get(0);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)entry).startsWith((CharSequence)"ENTER[ FLOW ] TRACE Enter")).contains(new CharSequence[]{"(int foo=1234567890)"})).doesNotContain(new CharSequence[]{"FormattedMessage"});
    }

    @Test
    public void flowTracing_SupplierOfJsonMessage() {
        Properties props = new Properties();
        props.setProperty("foo", "bar");
        this.logger.traceEntry(new Supplier[]{() -> new JsonMessage(props)});
        Assertions.assertThat(this.results).hasSize(1);
        String entry = this.results.get(0);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)entry).startsWith((CharSequence)"ENTER[ FLOW ] TRACE Enter")).contains(new CharSequence[]{"\"foo\":\"bar\""})).doesNotContain(new CharSequence[]{"JsonMessage"});
    }

    @Test
    public void flowTracing_SupplierOfLocalizedMessage() {
        this.logger.traceEntry(new Supplier[]{() -> new LocalizedMessage("int foo={}", (Object)1234567890)});
        Assertions.assertThat(this.results).hasSize(1);
        String entry = this.results.get(0);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)entry).startsWith((CharSequence)"ENTER[ FLOW ] TRACE Enter")).contains(new CharSequence[]{"(int foo=1234567890)"})).doesNotContain(new CharSequence[]{"LocalizedMessage"});
    }

    @Test
    public void flowTracing_SupplierOfLong() {
        this.logger.traceEntry(new Supplier[]{() -> 1234567890L});
        Assertions.assertThat(this.results).hasSize(1);
        String entry = this.results.get(0);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)entry).startsWith((CharSequence)"ENTER[ FLOW ] TRACE Enter")).contains(new CharSequence[]{"(1234567890)"})).doesNotContain(new CharSequence[]{"SimpleMessage"});
    }

    @Test
    public void flowTracing_SupplierOfMessageFormatMessage() {
        this.logger.traceEntry(new Supplier[]{() -> new MessageFormatMessage("int foo={0}", new Object[]{1234567890})});
        Assertions.assertThat(this.results).hasSize(1);
        String entry = this.results.get(0);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)entry).startsWith((CharSequence)"ENTER[ FLOW ] TRACE Enter")).contains(new CharSequence[]{"(int foo=1,234,567,890)"})).doesNotContain(new CharSequence[]{"MessageFormatMessage"});
    }

    @Test
    public void flowTracing_SupplierOfObjectArrayMessage() {
        this.logger.traceEntry(new Supplier[]{() -> new ObjectArrayMessage(new Object[]{1234567890})});
        Assertions.assertThat(this.results).hasSize(1);
        String entry = this.results.get(0);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)entry).startsWith((CharSequence)"ENTER[ FLOW ] TRACE Enter")).contains(new CharSequence[]{"([1234567890])"})).doesNotContain(new CharSequence[]{"ObjectArrayMessage"});
    }

    @Test
    public void flowTracing_SupplierOfObjectMessage() {
        this.logger.traceEntry(new Supplier[]{() -> new ObjectMessage((Object)1234567890)});
        Assertions.assertThat(this.results).hasSize(1);
        String entry = this.results.get(0);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)entry).startsWith((CharSequence)"ENTER[ FLOW ] TRACE Enter")).contains(new CharSequence[]{"(1234567890)"})).doesNotContain(new CharSequence[]{"ObjectMessage"});
    }

    @Test
    public void flowTracing_SupplierOfParameterizedMessage() {
        this.logger.traceEntry(new Supplier[]{() -> new ParameterizedMessage("int foo={}", (Object)1234567890)});
        Assertions.assertThat(this.results).hasSize(1);
        String entry = this.results.get(0);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)entry).startsWith((CharSequence)"ENTER[ FLOW ] TRACE Enter")).contains(new CharSequence[]{"(int foo=1234567890)"})).doesNotContain(new CharSequence[]{"ParameterizedMessage"});
    }

    @Test
    public void flowTracing_SupplierOfSimpleMessage() {
        this.logger.traceEntry(new Supplier[]{() -> new SimpleMessage("1234567890")});
        Assertions.assertThat(this.results).hasSize(1);
        String entry = this.results.get(0);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)entry).startsWith((CharSequence)"ENTER[ FLOW ] TRACE Enter")).contains(new CharSequence[]{"(1234567890)"})).doesNotContain(new CharSequence[]{"SimpleMessage"});
    }

    @Test
    public void flowTracing_SupplierOfString() {
        this.logger.traceEntry(new Supplier[]{() -> "1234567890"});
        Assertions.assertThat(this.results).hasSize(1);
        String entry = this.results.get(0);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)entry).startsWith((CharSequence)"ENTER[ FLOW ] TRACE Enter")).contains(new CharSequence[]{"(1234567890)"})).doesNotContain(new CharSequence[]{"SimpleMessage"});
    }

    @Test
    public void flowTracing_SupplierOfStringFormattedMessage() {
        this.logger.traceEntry(new Supplier[]{() -> new StringFormattedMessage("int foo=%,d", new Object[]{1234567890})});
        Assertions.assertThat(this.results).hasSize(1);
        String entry = this.results.get(0);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)entry).startsWith((CharSequence)"ENTER[ FLOW ] TRACE Enter")).contains(new CharSequence[]{"(int foo=1,234,567,890)"})).doesNotContain(new CharSequence[]{"StringFormattedMessage"});
    }

    @Test
    public void flowTracing_SupplierOfThreadDumpMessage() {
        this.logger.traceEntry(new Supplier[]{() -> new ThreadDumpMessage("Title of ...")});
        Assertions.assertThat(this.results).hasSize(1);
        String entry = this.results.get(0);
        ((AbstractStringAssert)Assertions.assertThat((String)entry).startsWith((CharSequence)"ENTER[ FLOW ] TRACE Enter")).contains(new CharSequence[]{"RUNNABLE", "Title of ...", this.getClass().getName()});
    }

    @BeforeEach
    public void setup() {
        this.results.clear();
        this.defaultLocale = Locale.getDefault(Locale.Category.FORMAT);
        Locale.setDefault(Locale.Category.FORMAT, Locale.US);
    }

    @AfterEach
    public void tearDown() {
        Locale.setDefault(Locale.Category.FORMAT, this.defaultLocale);
    }
}

