/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import org.apache.logging.log4j.util.Unbox;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceLock;

@ResourceLock(value="java.lang.System.properties")
public class Unbox1Test {
    @BeforeAll
    public static void beforeClass() {
        System.clearProperty("log4j.unbox.ringbuffer.size");
    }

    @Test
    public void testBoxClaimsItHas32Slots() {
        Assertions.assertEquals((int)32, (int)Unbox.getRingbufferSize());
    }

    @Test
    public void testBoxHas32Slots() {
        int MAX = 32;
        StringBuilder[] probe = new StringBuilder[96];
        int i = 0;
        while (i <= probe.length - 8) {
            probe[i++] = Unbox.box((boolean)true);
            probe[i++] = Unbox.box((char)'c');
            probe[i++] = Unbox.box((byte)127);
            probe[i++] = Unbox.box((double)Double.MAX_VALUE);
            probe[i++] = Unbox.box((float)Float.MAX_VALUE);
            probe[i++] = Unbox.box((int)Integer.MAX_VALUE);
            probe[i++] = Unbox.box((long)Long.MAX_VALUE);
            probe[i++] = Unbox.box((short)Short.MAX_VALUE);
        }
        for (i = 0; i < probe.length - 32; ++i) {
            Assertions.assertSame((Object)probe[i], (Object)probe[i + 32], (String)("probe[" + i + "], probe[" + (i + 32) + "]"));
            for (int j = 1; j < 31; ++j) {
                Assertions.assertNotSame((Object)probe[i], (Object)probe[i + j], (String)("probe[" + i + "], probe[" + (i + j) + "]"));
            }
        }
    }

    @Test
    public void testBoxBoolean() {
        Assertions.assertEquals((Object)"true", (Object)Unbox.box((boolean)true).toString());
        Assertions.assertEquals((Object)"false", (Object)Unbox.box((boolean)false).toString());
    }

    @Test
    public void testBoxByte() {
        Assertions.assertEquals((Object)"0", (Object)Unbox.box((byte)0).toString());
        Assertions.assertEquals((Object)"1", (Object)Unbox.box((byte)1).toString());
        Assertions.assertEquals((Object)"127", (Object)Unbox.box((byte)127).toString());
        Assertions.assertEquals((Object)"-1", (Object)Unbox.box((byte)-1).toString());
        Assertions.assertEquals((Object)"-128", (Object)Unbox.box((byte)-128).toString());
    }

    @Test
    public void testBoxChar() {
        Assertions.assertEquals((Object)"a", (Object)Unbox.box((char)'a').toString());
        Assertions.assertEquals((Object)"b", (Object)Unbox.box((char)'b').toString());
        Assertions.assertEquals((Object)"\u5b57", (Object)Unbox.box((char)'\u5b57').toString());
    }

    @Test
    public void testBoxDouble() {
        Assertions.assertEquals((Object)"3.14", (Object)Unbox.box((double)3.14).toString());
        Assertions.assertEquals((Object)Double.toString(Double.MAX_VALUE), (Object)Unbox.box((double)Double.MAX_VALUE).toString());
        Assertions.assertEquals((Object)Double.toString(Double.MIN_VALUE), (Object)Unbox.box((double)Double.MIN_VALUE).toString());
    }

    @Test
    public void testBoxFloat() {
        Assertions.assertEquals((Object)"3.14", (Object)Unbox.box((float)3.14f).toString());
        Assertions.assertEquals((Object)Float.toString(Float.MAX_VALUE), (Object)Unbox.box((float)Float.MAX_VALUE).toString());
        Assertions.assertEquals((Object)Float.toString(Float.MIN_VALUE), (Object)Unbox.box((float)Float.MIN_VALUE).toString());
    }

    @Test
    public void testBoxInt() {
        Assertions.assertEquals((Object)"0", (Object)Unbox.box((int)0).toString());
        Assertions.assertEquals((Object)"1", (Object)Unbox.box((int)1).toString());
        Assertions.assertEquals((Object)"127", (Object)Unbox.box((int)127).toString());
        Assertions.assertEquals((Object)"-1", (Object)Unbox.box((int)-1).toString());
        Assertions.assertEquals((Object)"-128", (Object)Unbox.box((int)-128).toString());
        Assertions.assertEquals((Object)Integer.toString(Integer.MAX_VALUE), (Object)Unbox.box((int)Integer.MAX_VALUE).toString());
        Assertions.assertEquals((Object)Integer.toString(Integer.MIN_VALUE), (Object)Unbox.box((int)Integer.MIN_VALUE).toString());
    }

    @Test
    public void testBoxLong() {
        Assertions.assertEquals((Object)"0", (Object)Unbox.box((long)0L).toString());
        Assertions.assertEquals((Object)"1", (Object)Unbox.box((long)1L).toString());
        Assertions.assertEquals((Object)"127", (Object)Unbox.box((long)127L).toString());
        Assertions.assertEquals((Object)"-1", (Object)Unbox.box((long)-1L).toString());
        Assertions.assertEquals((Object)"-128", (Object)Unbox.box((long)-128L).toString());
        Assertions.assertEquals((Object)Long.toString(Long.MAX_VALUE), (Object)Unbox.box((long)Long.MAX_VALUE).toString());
        Assertions.assertEquals((Object)Long.toString(Long.MIN_VALUE), (Object)Unbox.box((long)Long.MIN_VALUE).toString());
    }

    @Test
    public void testBoxShort() {
        Assertions.assertEquals((Object)"0", (Object)Unbox.box((short)0).toString());
        Assertions.assertEquals((Object)"1", (Object)Unbox.box((short)1).toString());
        Assertions.assertEquals((Object)"127", (Object)Unbox.box((short)127).toString());
        Assertions.assertEquals((Object)"-1", (Object)Unbox.box((short)-1).toString());
        Assertions.assertEquals((Object)"-128", (Object)Unbox.box((short)-128).toString());
        Assertions.assertEquals((Object)Short.toString((short)Short.MAX_VALUE), (Object)Unbox.box((short)Short.MAX_VALUE).toString());
        Assertions.assertEquals((Object)Short.toString((short)Short.MIN_VALUE), (Object)Unbox.box((short)Short.MIN_VALUE).toString());
    }

    @Test
    public void testBoxIsThreadLocal() throws Exception {
        StringBuilder[] probe = new StringBuilder[48];
        this.populate(0, probe);
        Thread t1 = new Thread(() -> this.populate(16, probe));
        t1.start();
        t1.join();
        Thread t2 = new Thread(() -> this.populate(16, probe));
        t2.start();
        t2.join();
        for (int i = 0; i < probe.length - 16; ++i) {
            for (int j = 1; j < 16; ++j) {
                Assertions.assertNotSame((Object)probe[i], (Object)probe[i + j], (String)("probe[" + i + "]=" + probe[i] + ", probe[" + (i + j) + "]=" + probe[i + j]));
            }
        }
    }

    private void populate(int start, StringBuilder[] probe) {
        int i = start;
        while (i <= start + 8) {
            probe[i++] = Unbox.box((boolean)true);
            probe[i++] = Unbox.box((char)'c');
            probe[i++] = Unbox.box((byte)127);
            probe[i++] = Unbox.box((double)Double.MAX_VALUE);
            probe[i++] = Unbox.box((float)Float.MAX_VALUE);
            probe[i++] = Unbox.box((int)Integer.MAX_VALUE);
            probe[i++] = Unbox.box((long)Long.MAX_VALUE);
            probe[i++] = Unbox.box((short)Short.MAX_VALUE);
        }
    }
}

