/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.TestLogger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.message.EntryMessage;
import org.apache.logging.log4j.message.JsonMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.message.SimpleMessageFactory;
import org.apache.logging.log4j.message.StringFormatterMessageFactory;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.apache.logging.log4j.spi.MessageFactory2Adapter;
import org.apache.logging.log4j.util.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.junit.jupiter.api.parallel.ResourceLocks;

@ResourceLocks(value={@ResourceLock(value="log4j2.MarkerManager"), @ResourceLock(value="log4j2.TestLogger")})
public class LoggerTest {
    private final TestLogger logger = (TestLogger)LogManager.getLogger((String)"LoggerTest");
    private final Marker marker = MarkerManager.getMarker((String)"test");
    private final List<String> results = this.logger.getEntries();

    @Test
    public void builder() {
        this.logger.atDebug().withLocation().log("Hello");
        this.logger.atError().withMarker(this.marker).log("Hello {}", (Object)"John");
        this.logger.atWarn().withThrowable(new Throwable("This is a test")).log((Message)new SimpleMessage("Log4j rocks!"));
        Assertions.assertEquals((int)3, (int)this.results.size());
        MatcherAssert.assertThat((String)"Incorrect message 1", (Object)this.results.get(0), (Matcher)CoreMatchers.equalTo((Object)" DEBUG org.apache.logging.log4j.LoggerTest.builder(LoggerTest.java:62) Hello"));
        MatcherAssert.assertThat((String)"Incorrect message 2", (Object)this.results.get(1), (Matcher)CoreMatchers.equalTo((Object)"test ERROR Hello John"));
        MatcherAssert.assertThat((String)"Incorrect message 3", (Object)this.results.get(2), (Matcher)CoreMatchers.startsWith((String)" WARN Log4j rocks! java.lang.Throwable: This is a test"));
        MatcherAssert.assertThat((String)"Throwable incorrect in message 3", (Object)this.results.get(2), (Matcher)CoreMatchers.containsString((String)"at org.apache.logging.log4j.LoggerTest.builder(LoggerTest.java:64)"));
    }

    @Test
    public void basicFlow() {
        this.logger.entry();
        this.logger.exit();
        Assertions.assertEquals((int)2, (int)this.results.size());
        MatcherAssert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.equalTo((Object)"ENTER[ FLOW ] TRACE Enter"));
        MatcherAssert.assertThat((String)"incorrect Exit", (Object)this.results.get(1), (Matcher)CoreMatchers.equalTo((Object)"EXIT[ FLOW ] TRACE Exit"));
    }

    @Test
    public void flowTracingMessage() {
        Properties props = new Properties();
        props.setProperty("foo", "bar");
        this.logger.traceEntry(new JsonMessage(props));
        Response response = new Response(-1, "Generic error");
        this.logger.traceExit(new JsonMessage(response), response);
        Assertions.assertEquals((int)2, (int)this.results.size());
        MatcherAssert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        MatcherAssert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"\"foo\":\"bar\""));
        MatcherAssert.assertThat((String)"incorrect Exit", (Object)this.results.get(1), (Matcher)CoreMatchers.startsWith((String)"EXIT[ FLOW ] TRACE Exit"));
        MatcherAssert.assertThat((String)"Missing exit data", (Object)this.results.get(1), (Matcher)CoreMatchers.containsString((String)"\"message\":\"Generic error\""));
    }

    @Test
    public void flowTracingString_ObjectArray1() {
        this.logger.traceEntry("doFoo(a={}, b={})", new Object[]{1, 2});
        this.logger.traceExit("doFoo(a=1, b=2): {}", 3);
        Assertions.assertEquals((int)2, (int)this.results.size());
        MatcherAssert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        MatcherAssert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"doFoo(a=1, b=2)"));
        MatcherAssert.assertThat((String)"Incorrect Exit", (Object)this.results.get(1), (Matcher)CoreMatchers.startsWith((String)"EXIT[ FLOW ] TRACE Exit"));
        MatcherAssert.assertThat((String)"Missing exit data", (Object)this.results.get(1), (Matcher)CoreMatchers.containsString((String)"doFoo(a=1, b=2): 3"));
    }

    @Test
    public void flowTracingExitValueOnly() {
        this.logger.traceEntry("doFoo(a={}, b={})", new Object[]{1, 2});
        this.logger.traceExit(3);
        Assertions.assertEquals((int)2, (int)this.results.size());
        MatcherAssert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        MatcherAssert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"doFoo(a=1, b=2)"));
        MatcherAssert.assertThat((String)"Incorrect Exit", (Object)this.results.get(1), (Matcher)CoreMatchers.startsWith((String)"EXIT[ FLOW ] TRACE Exit"));
        MatcherAssert.assertThat((String)"Missing exit data", (Object)this.results.get(1), (Matcher)CoreMatchers.containsString((String)"3"));
    }

    @Test
    public void flowTracingString_ObjectArray2() {
        EntryMessage msg = this.logger.traceEntry("doFoo(a={}, b={})", new Object[]{1, 2});
        this.logger.traceExit(msg, 3);
        Assertions.assertEquals((int)2, (int)this.results.size());
        MatcherAssert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        MatcherAssert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"doFoo(a=1, b=2)"));
        MatcherAssert.assertThat((String)"Incorrect Exit", (Object)this.results.get(1), (Matcher)CoreMatchers.startsWith((String)"EXIT[ FLOW ] TRACE Exit"));
        MatcherAssert.assertThat((String)"Missing exit data", (Object)this.results.get(1), (Matcher)CoreMatchers.containsString((String)"doFoo(a=1, b=2): 3"));
    }

    @Test
    public void flowTracingVoidReturn() {
        EntryMessage msg = this.logger.traceEntry("doFoo(a={}, b={})", new Object[]{1, 2});
        this.logger.traceExit(msg);
        Assertions.assertEquals((int)2, (int)this.results.size());
        MatcherAssert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        MatcherAssert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"doFoo(a=1, b=2)"));
        MatcherAssert.assertThat((String)"Incorrect Exit", (Object)this.results.get(1), (Matcher)CoreMatchers.startsWith((String)"EXIT[ FLOW ] TRACE Exit"));
        MatcherAssert.assertThat((String)"Missing exit data", (Object)this.results.get(1), (Matcher)CoreMatchers.endsWith((String)"doFoo(a=1, b=2)"));
    }

    @Test
    public void flowTracingNoExitArgs() {
        this.logger.traceEntry();
        this.logger.traceExit();
        Assertions.assertEquals((int)2, (int)this.results.size());
        MatcherAssert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        MatcherAssert.assertThat((String)"Incorrect Exit", (Object)this.results.get(1), (Matcher)CoreMatchers.startsWith((String)"EXIT[ FLOW ] TRACE Exit"));
    }

    @Test
    public void flowTracingNoArgs() {
        EntryMessage message = this.logger.traceEntry();
        this.logger.traceExit(message);
        Assertions.assertEquals((int)2, (int)this.results.size());
        MatcherAssert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        MatcherAssert.assertThat((String)"Incorrect Exit", (Object)this.results.get(1), (Matcher)CoreMatchers.startsWith((String)"EXIT[ FLOW ] TRACE Exit"));
    }

    @Test
    public void flowTracingString_SupplierOfObjectMessages() {
        EntryMessage msg = this.logger.traceEntry("doFoo(a={}, b={})", new Supplier[]{() -> new ObjectMessage((Object)1), () -> new ObjectMessage((Object)2)});
        this.logger.traceExit(msg, 3);
        Assertions.assertEquals((int)2, (int)this.results.size());
        MatcherAssert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        MatcherAssert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"doFoo(a=1, b=2)"));
        MatcherAssert.assertThat((String)"Incorrect Exit", (Object)this.results.get(1), (Matcher)CoreMatchers.startsWith((String)"EXIT[ FLOW ] TRACE Exit"));
        MatcherAssert.assertThat((String)"Missing exit data", (Object)this.results.get(1), (Matcher)CoreMatchers.containsString((String)"doFoo(a=1, b=2): 3"));
    }

    @Test
    public void flowTracingString_SupplierOfStrings() {
        EntryMessage msg = this.logger.traceEntry("doFoo(a={}, b={})", new Supplier[]{() -> "1", () -> "2"});
        this.logger.traceExit(msg, 3);
        Assertions.assertEquals((int)2, (int)this.results.size());
        MatcherAssert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTER[ FLOW ] TRACE Enter"));
        MatcherAssert.assertThat((String)"Missing entry data", (Object)this.results.get(0), (Matcher)CoreMatchers.containsString((String)"doFoo(a=1, b=2)"));
        MatcherAssert.assertThat((String)"Incorrect Exit", (Object)this.results.get(1), (Matcher)CoreMatchers.startsWith((String)"EXIT[ FLOW ] TRACE Exit"));
        MatcherAssert.assertThat((String)"Missing exit data", (Object)this.results.get(1), (Matcher)CoreMatchers.containsString((String)"doFoo(a=1, b=2): 3"));
    }

    @Test
    public void catching() {
        try {
            throw new NullPointerException();
        }
        catch (Exception e) {
            this.logger.catching(e);
            Assertions.assertEquals((int)1, (int)this.results.size());
            MatcherAssert.assertThat((String)"Incorrect Catching", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"CATCHING[ EXCEPTION ] ERROR Catching java.lang.NullPointerException"));
            return;
        }
    }

    @Test
    public void debug() {
        this.logger.debug("Debug message");
        Assertions.assertEquals((int)1, (int)this.results.size());
        Assertions.assertTrue((boolean)this.results.get(0).startsWith(" DEBUG Debug message"), (String)"Incorrect message");
    }

    @Test
    public void debugObject() {
        this.logger.debug(new Date());
        Assertions.assertEquals((int)1, (int)this.results.size());
        Assertions.assertTrue((this.results.get(0).length() > 7 ? 1 : 0) != 0, (String)"Invalid length");
    }

    @Test
    public void debugWithParms() {
        this.logger.debug("Hello, {}", "World");
        Assertions.assertEquals((int)1, (int)this.results.size());
        Assertions.assertTrue((boolean)this.results.get(0).startsWith(" DEBUG Hello, World"), (String)"Incorrect substitution");
    }

    @Test
    public void debugWithParmsAndThrowable() {
        this.logger.debug("Hello, {}", "World", new RuntimeException("Test Exception"));
        Assertions.assertEquals((int)1, (int)this.results.size());
        Assertions.assertTrue((boolean)this.results.get(0).startsWith(" DEBUG Hello, World java.lang.RuntimeException: Test Exception"), (String)("Unexpected results: " + this.results.get(0)));
    }

    @Test
    public void getFormatterLogger() {
        TestLogger testLogger = (TestLogger)LogManager.getFormatterLogger();
        TestLogger altLogger = (TestLogger)LogManager.getFormatterLogger(this.getClass());
        Assertions.assertEquals((Object)testLogger.getName(), (Object)altLogger.getName());
        Assertions.assertNotNull((Object)((Object)testLogger));
        LoggerTest.assertMessageFactoryInstanceOf(testLogger.getMessageFactory(), StringFormatterMessageFactory.class);
        this.assertEqualMessageFactory((MessageFactory)StringFormatterMessageFactory.INSTANCE, testLogger);
        testLogger.debug("%,d", Integer.MAX_VALUE);
        Assertions.assertEquals((int)1, (int)testLogger.getEntries().size());
        Assertions.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getFormatterLogger_Class() {
        TestLogger testLogger = (TestLogger)LogManager.getFormatterLogger(TestStringFormatterMessageFactory.class);
        Assertions.assertNotNull((Object)((Object)testLogger));
        LoggerTest.assertMessageFactoryInstanceOf(testLogger.getMessageFactory(), StringFormatterMessageFactory.class);
        this.assertEqualMessageFactory((MessageFactory)StringFormatterMessageFactory.INSTANCE, testLogger);
        testLogger.debug("%,d", Integer.MAX_VALUE);
        Assertions.assertEquals((int)1, (int)testLogger.getEntries().size());
        Assertions.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    private static void assertMessageFactoryInstanceOf(MessageFactory factory, Class<?> cls) {
        if (factory instanceof MessageFactory2Adapter) {
            factory = ((MessageFactory2Adapter)factory).getOriginal();
        }
        Assertions.assertTrue((boolean)factory.getClass().isAssignableFrom(cls));
    }

    @Test
    public void getFormatterLogger_Object() {
        TestLogger testLogger = (TestLogger)LogManager.getFormatterLogger((Object)new TestStringFormatterMessageFactory());
        Assertions.assertNotNull((Object)((Object)testLogger));
        LoggerTest.assertMessageFactoryInstanceOf(testLogger.getMessageFactory(), StringFormatterMessageFactory.class);
        this.assertEqualMessageFactory((MessageFactory)StringFormatterMessageFactory.INSTANCE, testLogger);
        testLogger.debug("%,d", Integer.MAX_VALUE);
        Assertions.assertEquals((int)1, (int)testLogger.getEntries().size());
        Assertions.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getFormatterLogger_String() {
        StringFormatterMessageFactory messageFactory = StringFormatterMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getFormatterLogger((String)"getLogger_String_StringFormatterMessageFactory");
        Assertions.assertNotNull((Object)((Object)testLogger));
        LoggerTest.assertMessageFactoryInstanceOf(testLogger.getMessageFactory(), StringFormatterMessageFactory.class);
        this.assertEqualMessageFactory((MessageFactory)messageFactory, testLogger);
        testLogger.debug("%,d", Integer.MAX_VALUE);
        Assertions.assertEquals((int)1, (int)testLogger.getEntries().size());
        Assertions.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLogger_Class_ParameterizedMessageFactory() {
        ParameterizedMessageFactory messageFactory = ParameterizedMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getLogger(TestParameterizedMessageFactory.class, (MessageFactory)messageFactory);
        Assertions.assertNotNull((Object)((Object)testLogger));
        this.assertEqualMessageFactory((MessageFactory)messageFactory, testLogger);
        testLogger.debug("{}", Integer.MAX_VALUE);
        Assertions.assertEquals((int)1, (int)testLogger.getEntries().size());
        Assertions.assertEquals((Object)" DEBUG 2147483647", (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLogger_Class_StringFormatterMessageFactory() {
        TestLogger testLogger = (TestLogger)LogManager.getLogger(TestStringFormatterMessageFactory.class, (MessageFactory)StringFormatterMessageFactory.INSTANCE);
        Assertions.assertNotNull((Object)((Object)testLogger));
        this.assertEqualMessageFactory((MessageFactory)StringFormatterMessageFactory.INSTANCE, testLogger);
        testLogger.debug("%,d", Integer.MAX_VALUE);
        Assertions.assertEquals((int)1, (int)testLogger.getEntries().size());
        Assertions.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLogger_Object_ParameterizedMessageFactory() {
        ParameterizedMessageFactory messageFactory = ParameterizedMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getLogger((Object)new TestParameterizedMessageFactory(), (MessageFactory)messageFactory);
        Assertions.assertNotNull((Object)((Object)testLogger));
        this.assertEqualMessageFactory((MessageFactory)messageFactory, testLogger);
        testLogger.debug("{}", Integer.MAX_VALUE);
        Assertions.assertEquals((int)1, (int)testLogger.getEntries().size());
        Assertions.assertEquals((Object)" DEBUG 2147483647", (Object)testLogger.getEntries().get(0));
    }

    private void assertEqualMessageFactory(MessageFactory messageFactory, TestLogger testLogger) {
        MessageFactory actual = testLogger.getMessageFactory();
        if (actual instanceof MessageFactory2Adapter) {
            actual = ((MessageFactory2Adapter)actual).getOriginal();
        }
        Assertions.assertEquals((Object)messageFactory, (Object)actual);
    }

    @Test
    public void getLogger_Object_StringFormatterMessageFactory() {
        StringFormatterMessageFactory messageFactory = StringFormatterMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getLogger((Object)new TestStringFormatterMessageFactory(), (MessageFactory)messageFactory);
        Assertions.assertNotNull((Object)((Object)testLogger));
        this.assertEqualMessageFactory((MessageFactory)messageFactory, testLogger);
        testLogger.debug("%,d", Integer.MAX_VALUE);
        Assertions.assertEquals((int)1, (int)testLogger.getEntries().size());
        Assertions.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLogger_String_MessageFactoryMismatch() {
        StringFormatterMessageFactory messageFactory = StringFormatterMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getLogger((String)"getLogger_String_MessageFactoryMismatch", (MessageFactory)messageFactory);
        Assertions.assertNotNull((Object)((Object)testLogger));
        this.assertEqualMessageFactory((MessageFactory)messageFactory, testLogger);
        TestLogger testLogger2 = (TestLogger)LogManager.getLogger((String)"getLogger_String_MessageFactoryMismatch", (MessageFactory)ParameterizedMessageFactory.INSTANCE);
        Assertions.assertNotNull((Object)((Object)testLogger2));
        testLogger.debug("%,d", Integer.MAX_VALUE);
        Assertions.assertEquals((int)1, (int)testLogger.getEntries().size());
        Assertions.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLogger_String_ParameterizedMessageFactory() {
        ParameterizedMessageFactory messageFactory = ParameterizedMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getLogger((String)"getLogger_String_ParameterizedMessageFactory", (MessageFactory)messageFactory);
        Assertions.assertNotNull((Object)((Object)testLogger));
        this.assertEqualMessageFactory((MessageFactory)messageFactory, testLogger);
        testLogger.debug("{}", Integer.MAX_VALUE);
        Assertions.assertEquals((int)1, (int)testLogger.getEntries().size());
        Assertions.assertEquals((Object)" DEBUG 2147483647", (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLogger_String_SimpleMessageFactory() {
        SimpleMessageFactory messageFactory = SimpleMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getLogger((String)"getLogger_String_StringFormatterMessageFactory", (MessageFactory)messageFactory);
        Assertions.assertNotNull((Object)((Object)testLogger));
        this.assertEqualMessageFactory((MessageFactory)messageFactory, testLogger);
        testLogger.debug("{} %,d {foo}", Integer.MAX_VALUE);
        Assertions.assertEquals((int)1, (int)testLogger.getEntries().size());
        Assertions.assertEquals((Object)" DEBUG {} %,d {foo}", (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLogger_String_StringFormatterMessageFactory() {
        StringFormatterMessageFactory messageFactory = StringFormatterMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getLogger((String)"getLogger_String_StringFormatterMessageFactory", (MessageFactory)messageFactory);
        Assertions.assertNotNull((Object)((Object)testLogger));
        this.assertEqualMessageFactory((MessageFactory)messageFactory, testLogger);
        testLogger.debug("%,d", Integer.MAX_VALUE);
        Assertions.assertEquals((int)1, (int)testLogger.getEntries().size());
        Assertions.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLoggerByClass() {
        Logger classLogger = LogManager.getLogger(LoggerTest.class);
        Assertions.assertNotNull((Object)classLogger);
    }

    @Test
    public void getLoggerByNullClass() {
        Assertions.assertNotNull((Object)LogManager.getLogger((Class)null));
    }

    @Test
    public void getLoggerByNullObject() {
        Assertions.assertNotNull((Object)LogManager.getLogger(null));
    }

    @Test
    public void getLoggerByNullString() {
        Assertions.assertNotNull((Object)LogManager.getLogger((String)null));
    }

    @Test
    public void getLoggerByObject() {
        Logger classLogger = LogManager.getLogger((Object)this);
        Assertions.assertNotNull((Object)classLogger);
        Assertions.assertEquals((Object)classLogger, (Object)LogManager.getLogger(LoggerTest.class));
    }

    @Test
    public void getRootLogger() {
        Assertions.assertNotNull((Object)LogManager.getRootLogger());
        Assertions.assertNotNull((Object)LogManager.getLogger((String)""));
        Assertions.assertNotNull((Object)LogManager.getLogger((String)""));
        Assertions.assertEquals((Object)LogManager.getRootLogger(), (Object)LogManager.getLogger((String)""));
        Assertions.assertEquals((Object)LogManager.getRootLogger(), (Object)LogManager.getLogger((String)""));
    }

    @Test
    public void isAllEnabled() {
        Assertions.assertTrue((boolean)this.logger.isEnabled(Level.ALL), (String)"Incorrect level");
    }

    @Test
    public void isDebugEnabled() {
        Assertions.assertTrue((boolean)this.logger.isDebugEnabled(), (String)"Incorrect level");
        Assertions.assertTrue((boolean)this.logger.isEnabled(Level.DEBUG), (String)"Incorrect level");
    }

    @Test
    public void isErrorEnabled() {
        Assertions.assertTrue((boolean)this.logger.isErrorEnabled(), (String)"Incorrect level");
        Assertions.assertTrue((boolean)this.logger.isEnabled(Level.ERROR), (String)"Incorrect level");
    }

    @Test
    public void isFatalEnabled() {
        Assertions.assertTrue((boolean)this.logger.isFatalEnabled(), (String)"Incorrect level");
        Assertions.assertTrue((boolean)this.logger.isEnabled(Level.FATAL), (String)"Incorrect level");
    }

    @Test
    public void isInfoEnabled() {
        Assertions.assertTrue((boolean)this.logger.isInfoEnabled(), (String)"Incorrect level");
        Assertions.assertTrue((boolean)this.logger.isEnabled(Level.INFO), (String)"Incorrect level");
    }

    @Test
    public void isOffEnabled() {
        Assertions.assertTrue((boolean)this.logger.isEnabled(Level.OFF), (String)"Incorrect level");
    }

    @Test
    public void isTraceEnabled() {
        Assertions.assertTrue((boolean)this.logger.isTraceEnabled(), (String)"Incorrect level");
        Assertions.assertTrue((boolean)this.logger.isEnabled(Level.TRACE), (String)"Incorrect level");
    }

    @Test
    public void isWarnEnabled() {
        Assertions.assertTrue((boolean)this.logger.isWarnEnabled(), (String)"Incorrect level");
        Assertions.assertTrue((boolean)this.logger.isEnabled(Level.WARN), (String)"Incorrect level");
    }

    @Test
    public void isAllEnabledWithMarker() {
        Assertions.assertTrue((boolean)this.logger.isEnabled(Level.ALL, this.marker), (String)"Incorrect level");
    }

    @Test
    public void isDebugEnabledWithMarker() {
        Assertions.assertTrue((boolean)this.logger.isDebugEnabled(this.marker), (String)"Incorrect level");
        Assertions.assertTrue((boolean)this.logger.isEnabled(Level.DEBUG, this.marker), (String)"Incorrect level");
    }

    @Test
    public void isErrorEnabledWithMarker() {
        Assertions.assertTrue((boolean)this.logger.isErrorEnabled(this.marker), (String)"Incorrect level");
        Assertions.assertTrue((boolean)this.logger.isEnabled(Level.ERROR, this.marker), (String)"Incorrect level");
    }

    @Test
    public void isFatalEnabledWithMarker() {
        Assertions.assertTrue((boolean)this.logger.isFatalEnabled(this.marker), (String)"Incorrect level");
        Assertions.assertTrue((boolean)this.logger.isEnabled(Level.FATAL, this.marker), (String)"Incorrect level");
    }

    @Test
    public void isInfoEnabledWithMarker() {
        Assertions.assertTrue((boolean)this.logger.isInfoEnabled(this.marker), (String)"Incorrect level");
        Assertions.assertTrue((boolean)this.logger.isEnabled(Level.INFO, this.marker), (String)"Incorrect level");
    }

    @Test
    public void isOffEnabledWithMarker() {
        Assertions.assertTrue((boolean)this.logger.isEnabled(Level.OFF, this.marker), (String)"Incorrect level");
    }

    @Test
    public void isTraceEnabledWithMarker() {
        Assertions.assertTrue((boolean)this.logger.isTraceEnabled(this.marker), (String)"Incorrect level");
        Assertions.assertTrue((boolean)this.logger.isEnabled(Level.TRACE, this.marker), (String)"Incorrect level");
    }

    @Test
    public void isWarnEnabledWithMarker() {
        Assertions.assertTrue((boolean)this.logger.isWarnEnabled(this.marker), (String)"Incorrect level");
        Assertions.assertTrue((boolean)this.logger.isEnabled(Level.WARN, this.marker), (String)"Incorrect level");
    }

    @Test
    public void mdc() {
        ThreadContext.put((String)"TestYear", (String)Integer.toString(2010));
        this.logger.debug("Debug message");
        String testYear = ThreadContext.get((String)"TestYear");
        Assertions.assertNotNull((Object)testYear, (String)"Test Year is null");
        Assertions.assertEquals((Object)"2010", (Object)testYear, (String)("Incorrect test year: " + testYear));
        ThreadContext.clearMap();
        this.logger.debug("Debug message");
        Assertions.assertEquals((int)2, (int)this.results.size());
        System.out.println("Log line 1: " + this.results.get(0));
        System.out.println("log line 2: " + this.results.get(1));
        Assertions.assertTrue((boolean)this.results.get(0).startsWith(" DEBUG Debug message {TestYear=2010}"), (String)("Incorrect MDC: " + this.results.get(0)));
        Assertions.assertTrue((boolean)this.results.get(1).startsWith(" DEBUG Debug message"), (String)("MDC not cleared?: " + this.results.get(1)));
    }

    @Test
    public void printf() {
        this.logger.printf(Level.DEBUG, "Debug message %d", new Object[]{1});
        this.logger.printf(Level.DEBUG, MarkerManager.getMarker((String)"Test"), "Debug message %d", new Object[]{2});
        Assertions.assertEquals((int)2, (int)this.results.size());
        MatcherAssert.assertThat((String)"Incorrect message", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)" DEBUG Debug message 1"));
        MatcherAssert.assertThat((String)"Incorrect message", (Object)this.results.get(1), (Matcher)CoreMatchers.startsWith((String)"Test DEBUG Debug message 2"));
    }

    @BeforeEach
    public void setup() {
        this.results.clear();
    }

    @Test
    public void structuredData() {
        ThreadContext.put((String)"loginId", (String)"JohnDoe");
        ThreadContext.put((String)"ipAddress", (String)"192.168.0.120");
        ThreadContext.put((String)"locale", (String)Locale.US.getDisplayName());
        StructuredDataMessage msg = new StructuredDataMessage("Audit@18060", "Transfer Complete", "Transfer");
        msg.put("ToAccount", "123456");
        msg.put("FromAccount", "123457");
        msg.put("Amount", "200.00");
        this.logger.info(MarkerManager.getMarker((String)"EVENT"), (Message)msg);
        ThreadContext.clearMap();
        Assertions.assertEquals((int)1, (int)this.results.size());
        MatcherAssert.assertThat((String)"Incorrect structured data: ", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"EVENT INFO Transfer [Audit@18060 Amount=\"200.00\" FromAccount=\"123457\" ToAccount=\"123456\"] Transfer Complete"));
    }

    @Test
    public void throwing() {
        this.logger.throwing(new IllegalArgumentException("Test Exception"));
        Assertions.assertEquals((int)1, (int)this.results.size());
        MatcherAssert.assertThat((String)"Incorrect Throwing", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"THROWING[ EXCEPTION ] ERROR Throwing java.lang.IllegalArgumentException: Test Exception"));
    }

    private static class Response {
        int status;
        String message;

        public Response(int status, String message) {
            this.status = status;
            this.message = message;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }

    private static class TestStringFormatterMessageFactory {
        private TestStringFormatterMessageFactory() {
        }
    }

    private static class TestParameterizedMessageFactory {
        private TestParameterizedMessageFactory() {
        }
    }
}

