/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceLock;

@ResourceLock(value="log4j2.MarkerManager")
public class MarkerTest {
    @BeforeEach
    public void setUp() {
        MarkerManager.clear();
    }

    @Test
    public void testGetMarker() {
        Marker expected = MarkerManager.getMarker((String)"A");
        Assertions.assertNull((Object)expected.getParents());
    }

    @Test
    public void testGetMarkerWithParents() {
        Marker expected = MarkerManager.getMarker((String)"A");
        Marker p1 = MarkerManager.getMarker((String)"P1");
        p1.addParents(new Marker[]{MarkerManager.getMarker((String)"PP1")});
        Marker p2 = MarkerManager.getMarker((String)"P2");
        expected.addParents(new Marker[]{p1});
        expected.addParents(new Marker[]{p2});
        Assertions.assertEquals((int)2, (int)expected.getParents().length);
    }

    @Test
    public void testHasParents() {
        Marker parent = MarkerManager.getMarker((String)"PARENT");
        Marker existing = MarkerManager.getMarker((String)"EXISTING");
        Assertions.assertFalse((boolean)existing.hasParents());
        existing.setParents(new Marker[]{parent});
        Assertions.assertTrue((boolean)existing.hasParents());
    }

    @Test
    public void testMarker() {
        Marker parent = MarkerManager.getMarker((String)"PARENT");
        Marker test1 = MarkerManager.getMarker((String)"TEST1").setParents(new Marker[]{parent});
        Marker test2 = MarkerManager.getMarker((String)"TEST2").addParents(new Marker[]{parent});
        Assertions.assertTrue((boolean)test1.isInstanceOf(parent), (String)"TEST1 is not an instance of PARENT");
        Assertions.assertTrue((boolean)test2.isInstanceOf(parent), (String)"TEST2 is not an instance of PARENT");
        Assertions.assertFalse((boolean)parent.isInstanceOf(test1));
        Assertions.assertFalse((boolean)parent.isInstanceOf(test2));
        Marker test3 = MarkerManager.getMarker((String)"TEST3").addParents(new Marker[]{test2});
        Assertions.assertTrue((boolean)test3.isInstanceOf(test2));
        Assertions.assertTrue((boolean)test3.isInstanceOf("TEST2"));
        Assertions.assertTrue((boolean)test3.isInstanceOf("PARENT"));
        Assertions.assertTrue((boolean)test2.isInstanceOf("PARENT"));
        Assertions.assertFalse((boolean)parent.isInstanceOf(test3));
        Assertions.assertFalse((boolean)parent.isInstanceOf(test3));
    }

    @Test
    public void testMarkerSharedIntermediaryMarker() {
        Marker parent1 = MarkerManager.getMarker((String)"PARENT1");
        Marker parent2 = MarkerManager.getMarker((String)"PARENT2");
        Marker test1 = MarkerManager.getMarker((String)"TEST1").setParents(new Marker[]{parent1, parent2});
        Assertions.assertTrue((boolean)test1.isInstanceOf(parent1));
        Marker leaf = MarkerManager.getMarker((String)"LEAF").setParents(new Marker[]{test1});
        Assertions.assertTrue((boolean)leaf.isInstanceOf("TEST1"));
        Assertions.assertTrue((boolean)leaf.isInstanceOf("PARENT1"));
        Assertions.assertTrue((boolean)leaf.isInstanceOf("PARENT2"));
    }

    @Test
    public void testMultipleParents() {
        Marker parent1 = MarkerManager.getMarker((String)"PARENT1");
        Marker parent2 = MarkerManager.getMarker((String)"PARENT2");
        Marker test1 = MarkerManager.getMarker((String)"TEST1").setParents(new Marker[]{parent1, parent2});
        Marker test2 = MarkerManager.getMarker((String)"TEST2").addParents(new Marker[]{parent1, parent2});
        Assertions.assertTrue((boolean)test1.isInstanceOf(parent1), (String)"TEST1 is not an instance of PARENT1");
        Assertions.assertTrue((boolean)test1.isInstanceOf("PARENT1"), (String)"TEST1 is not an instance of PARENT1");
        Assertions.assertTrue((boolean)test1.isInstanceOf(parent2), (String)"TEST1 is not an instance of PARENT2");
        Assertions.assertTrue((boolean)test1.isInstanceOf("PARENT2"), (String)"TEST1 is not an instance of PARENT2");
        Assertions.assertTrue((boolean)test2.isInstanceOf(parent1), (String)"TEST2 is not an instance of PARENT1");
        Assertions.assertTrue((boolean)test2.isInstanceOf("PARENT1"), (String)"TEST2 is not an instance of PARENT1");
        Assertions.assertTrue((boolean)test2.isInstanceOf(parent2), (String)"TEST2 is not an instance of PARENT2");
        Assertions.assertTrue((boolean)test2.isInstanceOf("PARENT2"), (String)"TEST2 is not an instance of PARENT2");
    }

    @Test
    public void testAddToExistingParents() {
        Marker parent = MarkerManager.getMarker((String)"PARENT");
        Marker existing = MarkerManager.getMarker((String)"EXISTING");
        Marker test1 = MarkerManager.getMarker((String)"TEST1").setParents(new Marker[]{existing});
        test1.addParents(new Marker[]{parent});
        Assertions.assertTrue((boolean)test1.isInstanceOf(parent), (String)"TEST1 is not an instance of PARENT");
        Assertions.assertTrue((boolean)test1.isInstanceOf("PARENT"), (String)"TEST1 is not an instance of PARENT");
        Assertions.assertTrue((boolean)test1.isInstanceOf(existing), (String)"TEST1 is not an instance of EXISTING");
        Assertions.assertTrue((boolean)test1.isInstanceOf("EXISTING"), (String)"TEST1 is not an instance of EXISTING");
    }

    @Test
    public void testDuplicateParents() {
        Marker parent = MarkerManager.getMarker((String)"PARENT");
        Marker existing = MarkerManager.getMarker((String)"EXISTING");
        Marker test1 = MarkerManager.getMarker((String)"TEST1").setParents(new Marker[]{existing});
        test1.addParents(new Marker[]{parent});
        Marker[] parents = test1.getParents();
        test1.addParents(new Marker[]{existing});
        Assertions.assertEquals((int)parents.length, (int)test1.getParents().length, (String)"duplicate add allowed");
        test1.addParents(new Marker[]{existing, MarkerManager.getMarker((String)"EXTRA")});
        Assertions.assertEquals((int)(parents.length + 1), (int)test1.getParents().length, (String)"incorrect add");
        Assertions.assertTrue((boolean)test1.isInstanceOf(parent), (String)"TEST1 is not an instance of PARENT");
        Assertions.assertTrue((boolean)test1.isInstanceOf("PARENT"), (String)"TEST1 is not an instance of PARENT");
        Assertions.assertTrue((boolean)test1.isInstanceOf(existing), (String)"TEST1 is not an instance of EXISTING");
        Assertions.assertTrue((boolean)test1.isInstanceOf("EXISTING"), (String)"TEST1 is not an instance of EXISTING");
    }
}

