/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.util.EnvironmentPropertySource;
import org.apache.logging.log4j.util.PropertySource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class EnvironmentPropertySourceTest {
    private final PropertySource source = new EnvironmentPropertySource();
    private final CharSequence expected;
    private final List<? extends CharSequence> tokens;

    public EnvironmentPropertySourceTest(CharSequence expected, List<? extends CharSequence> tokens) {
        this.expected = expected;
        this.tokens = tokens;
    }

    @Parameterized.Parameters(name="{0}")
    public static Object[][] data() {
        return new Object[][]{{"LOG4J_CONFIGURATION_FILE", Arrays.asList("configuration", "file")}, {"LOG4J_FOO_BAR_PROPERTY", Arrays.asList("foo", "bar", "property")}, {"LOG4J_EXACT", Collections.singletonList("EXACT")}, {"LOG4J_TEST_PROPERTY_NAME", PropertySource.Util.tokenize((CharSequence)"Log4jTestPropertyName")}};
    }

    @Test
    public void testNormalFormFollowsEnvironmentVariableConventions() throws Exception {
        Assert.assertEquals((Object)this.expected, (Object)this.source.getNormalForm(this.tokens));
    }
}

