/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spi;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;
import org.apache.logging.log4j.simple.SimpleLoggerContext;
import org.apache.logging.log4j.spi.AbstractLoggerAdapter;
import org.apache.logging.log4j.spi.LoggerContext;
import org.junit.Assert;
import org.junit.Test;

public class LoggerAdapterTest {
    @Test
    public synchronized void testGetLoggersInContextSynch() throws Exception {
        int i;
        TestLoggerAdapter adapter = new TestLoggerAdapter();
        int num = 500;
        CountDownLatch startSignal = new CountDownLatch(1);
        CountDownLatch doneSignal = new CountDownLatch(500);
        RunnableThreadTest[] instances = new RunnableThreadTest[500];
        SimpleLoggerContext lastUsedContext = null;
        for (i = 0; i < 500; ++i) {
            if (i % 2 == 0) {
                lastUsedContext = new SimpleLoggerContext();
            }
            RunnableThreadTest runnable = new RunnableThreadTest(i, adapter, (LoggerContext)lastUsedContext, startSignal, doneSignal);
            Thread thread = new Thread(runnable);
            thread.start();
            instances[i] = runnable;
        }
        startSignal.countDown();
        doneSignal.await();
        for (i = 0; i < 500; i += 2) {
            Map<String, Logger> resultMap1 = instances[i].getResultMap();
            Map<String, Logger> resultMap2 = instances[i + 1].getResultMap();
            Assert.assertSame((String)("not the same map for instances" + i + " and " + (i + 1) + ":"), resultMap1, resultMap2);
            Assert.assertEquals((long)2L, (long)resultMap1.size());
        }
    }

    private static class TestLoggerAdapter
    extends AbstractLoggerAdapter<Logger> {
        private TestLoggerAdapter() {
        }

        protected LoggerContext getContext() {
            return null;
        }

        protected Logger newLogger(String name, LoggerContext context) {
            return null;
        }
    }

    private static class TestLogger
    extends Logger {
        public TestLogger() {
            super("test", null);
        }
    }

    private class RunnableThreadTest
    implements Runnable {
        private final AbstractLoggerAdapter<Logger> adapter;
        private final LoggerContext context;
        private final CountDownLatch doneSignal;
        private final int index;
        private Map<String, Logger> resultMap;
        private final CountDownLatch startSignal;

        public RunnableThreadTest(int index, TestLoggerAdapter adapter, LoggerContext context, CountDownLatch startSignal, CountDownLatch doneSignal) {
            this.adapter = adapter;
            this.context = context;
            this.startSignal = startSignal;
            this.doneSignal = doneSignal;
            this.index = index;
        }

        public Map<String, Logger> getResultMap() {
            return this.resultMap;
        }

        @Override
        public void run() {
            try {
                this.startSignal.await();
                this.resultMap = this.adapter.getLoggersInContext(this.context);
                this.resultMap.put(String.valueOf(this.index), new TestLogger());
                this.doneSignal.countDown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

