/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.io.Closeable;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.apache.logging.log4j.spi.LoggerContext;
import org.junit.Assert;
import org.junit.Test;

public class LogManagerTest {
    @Test
    public void testGetLogger() {
        Logger logger = LogManager.getLogger();
        Assert.assertNotNull((String)"No Logger returned", (Object)logger);
        Assert.assertTrue((String)("Incorrect Logger name: " + logger.getName()), (boolean)LogManagerTest.class.getName().equals(logger.getName()));
        logger = LogManager.getLogger((MessageFactory)ParameterizedMessageFactory.INSTANCE);
        Assert.assertNotNull((String)"No Logger returned", (Object)logger);
        Assert.assertTrue((String)("Incorrect Logger name: " + logger.getName()), (boolean)LogManagerTest.class.getName().equals(logger.getName()));
        logger = LogManager.getLogger((Class)null);
        Assert.assertNotNull((String)"No Logger returned", (Object)logger);
        Assert.assertTrue((String)("Incorrect Logger name: " + logger.getName()), (boolean)LogManagerTest.class.getName().equals(logger.getName()));
        logger = LogManager.getLogger((Class)null, (MessageFactory)ParameterizedMessageFactory.INSTANCE);
        Assert.assertNotNull((String)"No Logger returned", (Object)logger);
        Assert.assertTrue((String)("Incorrect Logger name: " + logger.getName()), (boolean)LogManagerTest.class.getName().equals(logger.getName()));
        logger = LogManager.getLogger((String)null);
        Assert.assertNotNull((String)"No Logger returned", (Object)logger);
        Assert.assertTrue((String)("Incorrect Logger name: " + logger.getName()), (boolean)LogManagerTest.class.getName().equals(logger.getName()));
        logger = LogManager.getLogger((String)null, (MessageFactory)ParameterizedMessageFactory.INSTANCE);
        Assert.assertNotNull((String)"No Logger returned", (Object)logger);
        Assert.assertTrue((String)("Incorrect Logger name: " + logger.getName()), (boolean)LogManagerTest.class.getName().equals(logger.getName()));
        logger = LogManager.getLogger((Object)null);
        Assert.assertNotNull((String)"No Logger returned", (Object)logger);
        Assert.assertTrue((String)("Incorrect Logger name: " + logger.getName()), (boolean)LogManagerTest.class.getName().equals(logger.getName()));
        logger = LogManager.getLogger((Object)null, (MessageFactory)ParameterizedMessageFactory.INSTANCE);
        Assert.assertNotNull((String)"No Logger returned", (Object)logger);
        Assert.assertTrue((String)("Incorrect Logger name: " + logger.getName()), (boolean)LogManagerTest.class.getName().equals(logger.getName()));
    }

    @Test
    public void testGetLoggerForAnonymousInnerClass1() throws IOException {
        Closeable closeable = new Closeable(){
            Logger LOGGER = LogManager.getLogger();

            @Override
            public void close() throws IOException {
                Assert.assertEquals((Object)"org.apache.logging.log4j.LogManagerTest$1", (Object)this.LOGGER.getName());
            }
        };
        closeable.close();
    }

    @Test
    public void testGetLoggerForAnonymousInnerClass2() throws IOException {
        Closeable closeable = new Closeable(){
            Logger LOGGER = LogManager.getLogger(this.getClass());

            @Override
            public void close() throws IOException {
                Assert.assertEquals((Object)"org.apache.logging.log4j.LogManagerTest$2", (Object)this.LOGGER.getName());
            }
        };
        closeable.close();
    }

    @Test
    public void testGetLoggerForInner() {
        Assert.assertEquals((Object)"org.apache.logging.log4j.LogManagerTest.Inner", (Object)(LogManagerTest)this.new Inner().LOGGER.getName());
    }

    @Test
    public void testGetLoggerForInnerByClass() {
        Assert.assertEquals((Object)"org.apache.logging.log4j.LogManagerTest.InnerByClass", (Object)(LogManagerTest)this.new InnerByClass().LOGGER.getName());
    }

    @Test
    public void testGetLoggerForStaticInner() {
        Assert.assertEquals((Object)"org.apache.logging.log4j.LogManagerTest.StaticInner", (Object)StaticInner.LOGGER.getName());
    }

    @Test
    public void testGetLoggerForStaticInnerByClass() {
        Assert.assertEquals((Object)"org.apache.logging.log4j.LogManagerTest.StaticInnerByClass", (Object)StaticInnerByClass.LOGGER.getName());
    }

    @Test
    public void testShutdown() {
        LoggerContext loggerContext = LogManager.getContext((boolean)false);
    }

    static class StaticInnerByClass {
        static final Logger LOGGER = LogManager.getLogger(StaticInnerByClass.class);

        StaticInnerByClass() {
        }
    }

    static class StaticInner {
        static final Logger LOGGER = LogManager.getLogger();

        StaticInner() {
        }
    }

    class InnerByClass {
        final Logger LOGGER = LogManager.getLogger(InnerByClass.class);

        InnerByClass() {
        }
    }

    class Inner {
        final Logger LOGGER = LogManager.getLogger();

        Inner() {
        }
    }
}

