/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.util.PropertiesPropertySource;
import org.apache.logging.log4j.util.PropertySource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PropertiesPropertySourceTest {
    private final PropertySource source = new PropertiesPropertySource(new Properties());
    private final CharSequence expected;
    private final List<? extends CharSequence> tokens;

    public PropertiesPropertySourceTest(String expected, List<CharSequence> tokens) {
        this.expected = expected;
        this.tokens = tokens;
    }

    @Parameterized.Parameters(name="{0}")
    public static Object[][] data() {
        return new Object[][]{{"log4j2.configurationFile", Arrays.asList("configuration", "file")}, {"log4j2.fooBarProperty", Arrays.asList("foo", "bar", "property")}, {"log4j2.EXACT", Collections.singletonList("EXACT")}, {"log4j2.testPropertyName", PropertySource.Util.tokenize((CharSequence)"Log4jTestPropertyName")}};
    }

    @Test
    public void testNormalFormFollowsCamelCaseConventions() throws Exception {
        Assert.assertEquals((Object)this.expected, (Object)this.source.getNormalForm(this.tokens));
    }
}

