/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.ThreadContextUtilityClass;
import org.junit.Assert;
import org.junit.Test;

public class ThreadContextTest {
    public static void reinitThreadContext() {
        ThreadContext.init();
    }

    @Test
    public void testPush() {
        ThreadContext.push((String)"Hello");
        ThreadContext.push((String)"{} is {}", (Object[])new Object[]{ThreadContextTest.class.getSimpleName(), "running"});
        Assert.assertEquals((String)"Incorrect parameterized stack value", (Object)ThreadContext.pop(), (Object)"ThreadContextTest is running");
        Assert.assertEquals((String)"Incorrect simple stack value", (Object)ThreadContext.pop(), (Object)"Hello");
    }

    @Test
    public void testInheritanceSwitchedOffByDefault() throws Exception {
        ThreadContext.clearMap();
        ThreadContext.put((String)"Greeting", (String)"Hello");
        StringBuilder sb = new StringBuilder();
        TestThread thread = new TestThread(sb);
        thread.start();
        thread.join();
        String str = sb.toString();
        Assert.assertTrue((String)("Unexpected ThreadContext value. Expected null. Actual " + str), (boolean)"null".equals(str));
        sb = new StringBuilder();
        thread = new TestThread(sb);
        thread.start();
        thread.join();
        str = sb.toString();
        Assert.assertTrue((String)("Unexpected ThreadContext value. Expected null. Actual " + str), (boolean)"null".equals(str));
    }

    @Test
    public void perfTest() throws Exception {
        ThreadContextUtilityClass.perfTest();
    }

    @Test
    public void testGetContextReturnsEmptyMapIfEmpty() {
        ThreadContextUtilityClass.testGetContextReturnsEmptyMapIfEmpty();
    }

    @Test
    public void testGetContextReturnsMutableCopy() {
        ThreadContextUtilityClass.testGetContextReturnsMutableCopy();
    }

    @Test
    public void testGetImmutableContextReturnsEmptyMapIfEmpty() {
        ThreadContextUtilityClass.testGetImmutableContextReturnsEmptyMapIfEmpty();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetImmutableContextReturnsImmutableMapIfNonEmpty() {
        ThreadContextUtilityClass.testGetImmutableContextReturnsImmutableMapIfNonEmpty();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetImmutableContextReturnsImmutableMapIfEmpty() {
        ThreadContextUtilityClass.testGetImmutableContextReturnsImmutableMapIfEmpty();
    }

    @Test
    public void testGetImmutableStackReturnsEmptyStackIfEmpty() {
        ThreadContextUtilityClass.testGetImmutableStackReturnsEmptyStackIfEmpty();
    }

    @Test
    public void testPut() {
        ThreadContextUtilityClass.testPut();
    }

    @Test
    public void testPutAll() {
        int i;
        ThreadContext.clearMap();
        Assert.assertTrue((boolean)ThreadContext.isEmpty());
        Assert.assertFalse((boolean)ThreadContext.containsKey((String)"key"));
        int mapSize = 10;
        HashMap<String, String> newMap = new HashMap<String, String>(10);
        for (i = 1; i <= 10; ++i) {
            newMap.put("key" + i, "value" + i);
        }
        ThreadContext.putAll(newMap);
        Assert.assertFalse((boolean)ThreadContext.isEmpty());
        for (i = 1; i <= 10; ++i) {
            Assert.assertTrue((boolean)ThreadContext.containsKey((String)("key" + i)));
            Assert.assertEquals((Object)("value" + i), (Object)ThreadContext.get((String)("key" + i)));
        }
    }

    @Test
    public void testRemove() {
        ThreadContext.clearMap();
        Assert.assertNull((Object)ThreadContext.get((String)"testKey"));
        ThreadContext.put((String)"testKey", (String)"testValue");
        Assert.assertEquals((Object)"testValue", (Object)ThreadContext.get((String)"testKey"));
        ThreadContext.remove((String)"testKey");
        Assert.assertNull((Object)ThreadContext.get((String)"testKey"));
        Assert.assertTrue((boolean)ThreadContext.isEmpty());
    }

    @Test
    public void testRemoveAll() {
        ThreadContext.clearMap();
        ThreadContext.put((String)"testKey1", (String)"testValue1");
        ThreadContext.put((String)"testKey2", (String)"testValue2");
        Assert.assertEquals((Object)"testValue1", (Object)ThreadContext.get((String)"testKey1"));
        Assert.assertEquals((Object)"testValue2", (Object)ThreadContext.get((String)"testKey2"));
        Assert.assertFalse((boolean)ThreadContext.isEmpty());
        ThreadContext.removeAll(Arrays.asList("testKey1", "testKey2"));
        Assert.assertNull((Object)ThreadContext.get((String)"testKey1"));
        Assert.assertNull((Object)ThreadContext.get((String)"testKey2"));
        Assert.assertTrue((boolean)ThreadContext.isEmpty());
    }

    @Test
    public void testContainsKey() {
        ThreadContext.clearMap();
        Assert.assertFalse((boolean)ThreadContext.containsKey((String)"testKey"));
        ThreadContext.put((String)"testKey", (String)"testValue");
        Assert.assertTrue((boolean)ThreadContext.containsKey((String)"testKey"));
        ThreadContext.remove((String)"testKey");
        Assert.assertFalse((boolean)ThreadContext.containsKey((String)"testKey"));
    }

    private class TestThread
    extends Thread {
        private final StringBuilder sb;

        public TestThread(StringBuilder sb) {
            this.sb = sb;
        }

        @Override
        public void run() {
            String greeting = ThreadContext.get((String)"Greeting");
            if (greeting == null) {
                this.sb.append("null");
            } else {
                this.sb.append(greeting);
            }
            ThreadContext.clearMap();
        }
    }
}

