/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Stack;
import org.apache.logging.log4j.util.ReflectionUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.ParentRunner;
import sun.reflect.Reflection;

public class ReflectionUtilTest {
    @Before
    public void setUp() throws Exception {
        Assume.assumeTrue((boolean)ReflectionUtil.supportsFastReflection());
    }

    @Test
    public void testSunReflectionEquivalence() throws Exception {
        for (int i = 1; i < 6; ++i) {
            Assert.assertSame((Object)Reflection.getCallerClass((int)(i + ReflectionUtil.JDK_7u25_OFFSET)), (Object)ReflectionUtil.getCallerClass((int)i));
        }
    }

    @Test
    public void testStackTraceEquivalence() throws Exception {
        for (int i = 1; i < 15; ++i) {
            Class expected = Reflection.getCallerClass((int)(i + ReflectionUtil.JDK_7u25_OFFSET));
            Class actual = ReflectionUtil.getCallerClass((int)i);
            Class<?> fallbackActual = Class.forName(ReflectionUtil.getEquivalentStackTraceElement((int)i).getClassName());
            Assert.assertSame((Object)expected, (Object)actual);
            Assert.assertSame((Object)expected, fallbackActual);
        }
    }

    @Test
    public void testGetCallerClass() throws Exception {
        Class<ReflectionUtilTest> expected = ReflectionUtilTest.class;
        Class actual = ReflectionUtil.getCallerClass((int)1);
        Assert.assertSame(expected, (Object)actual);
    }

    @Test
    public void testGetCallerClassNameViaStackTrace() throws Exception {
        Class<ReflectionUtilTest> expected = ReflectionUtilTest.class;
        Class<?> actual = Class.forName(new Throwable().getStackTrace()[0].getClassName());
        Assert.assertSame(expected, actual);
    }

    @Test
    public void testGetCurrentStackTrace() throws Exception {
        Stack classes = ReflectionUtil.getCurrentStackTrace();
        Stack reversed = new Stack();
        reversed.ensureCapacity(classes.size());
        while (!classes.empty()) {
            reversed.push(classes.pop());
        }
        while (reversed.peek() != ReflectionUtil.class) {
            reversed.pop();
        }
        reversed.pop();
        Assert.assertSame(ReflectionUtilTest.class, reversed.pop());
    }

    @Test
    public void testGetCallerClassViaName() throws Exception {
        Class<BlockJUnit4ClassRunner> expected = BlockJUnit4ClassRunner.class;
        Class actual = ReflectionUtil.getCallerClass((String)"org.junit.runners.ParentRunner");
        Assert.assertSame(expected, (Object)actual);
    }

    @Test
    public void testGetCallerClassViaAnchorClass() throws Exception {
        Class<BlockJUnit4ClassRunner> expected = BlockJUnit4ClassRunner.class;
        Class actual = ReflectionUtil.getCallerClass(ParentRunner.class);
        Assert.assertSame(expected, (Object)actual);
    }
}

