/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.TestLogger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.apache.logging.log4j.message.StringFormatterMessageFactory;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LoggerTest {
    TestLogger logger = (TestLogger)LogManager.getLogger((String)"LoggerTest");
    List<String> results = this.logger.getEntries();

    @Test
    public void basicFlow() {
        this.logger.entry();
        this.logger.exit();
        Assert.assertEquals((long)2L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Entry", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"ENTRY[ FLOW ] TRACE entry"));
        Assert.assertThat((String)"incorrect Exit", (Object)this.results.get(1), (Matcher)CoreMatchers.startsWith((String)"EXIT[ FLOW ] TRACE exit"));
    }

    @Test
    public void catching() {
        try {
            throw new NullPointerException();
        }
        catch (Exception e) {
            this.logger.catching(e);
            Assert.assertEquals((long)1L, (long)this.results.size());
            Assert.assertThat((String)"Incorrect Catching", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"CATCHING[ EXCEPTION ] ERROR catching java.lang.NullPointerException"));
            return;
        }
    }

    @Test
    public void debug() {
        this.logger.debug("Debug message");
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertTrue((String)"Incorrect message", (boolean)this.results.get(0).startsWith(" DEBUG Debug message"));
    }

    @Test
    public void debugObject() {
        this.logger.debug(new Date());
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertTrue((String)"Invalid length", (this.results.get(0).length() > 7 ? 1 : 0) != 0);
    }

    @Test
    public void debugWithParms() {
        this.logger.debug("Hello, {}", new Object[]{"World"});
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertTrue((String)"Incorrect substitution", (boolean)this.results.get(0).startsWith(" DEBUG Hello, World"));
    }

    @Test
    public void debugWithParmsAndThrowable() {
        this.logger.debug("Hello, {}", new Object[]{"World", new RuntimeException("Test Exception")});
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertTrue((String)("Unexpected results: " + this.results.get(0)), (boolean)this.results.get(0).startsWith(" DEBUG Hello, World java.lang.RuntimeException: Test Exception"));
    }

    @Test
    public void getFormatterLogger_Class() {
        TestLogger testLogger = (TestLogger)LogManager.getFormatterLogger(TestStringFormatterMessageFactory.class);
        Assert.assertNotNull((Object)((Object)testLogger));
        Assert.assertTrue((boolean)(testLogger.getMessageFactory() instanceof StringFormatterMessageFactory));
        Assert.assertEquals((Object)StringFormatterMessageFactory.INSTANCE, (Object)testLogger.getMessageFactory());
        testLogger.debug("%,d", new Object[]{Integer.MAX_VALUE});
        Assert.assertEquals((long)1L, (long)testLogger.getEntries().size());
        Assert.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getFormatterLogger_Object() {
        TestLogger testLogger = (TestLogger)LogManager.getFormatterLogger((Object)new TestStringFormatterMessageFactory());
        Assert.assertNotNull((Object)((Object)testLogger));
        Assert.assertTrue((boolean)(testLogger.getMessageFactory() instanceof StringFormatterMessageFactory));
        Assert.assertEquals((Object)StringFormatterMessageFactory.INSTANCE, (Object)testLogger.getMessageFactory());
        testLogger.debug("%,d", new Object[]{Integer.MAX_VALUE});
        Assert.assertEquals((long)1L, (long)testLogger.getEntries().size());
        Assert.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getFormatterLogger_String() {
        StringFormatterMessageFactory messageFactory = StringFormatterMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getFormatterLogger((String)"getLogger_String_StringFormatterMessageFactory");
        Assert.assertNotNull((Object)((Object)testLogger));
        Assert.assertTrue((boolean)(testLogger.getMessageFactory() instanceof StringFormatterMessageFactory));
        Assert.assertEquals((Object)messageFactory, (Object)testLogger.getMessageFactory());
        testLogger.debug("%,d", new Object[]{Integer.MAX_VALUE});
        Assert.assertEquals((long)1L, (long)testLogger.getEntries().size());
        Assert.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLogger_Class_ParameterizedMessageFactory() {
        ParameterizedMessageFactory messageFactory = ParameterizedMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getLogger(TestParameterizedMessageFactory.class, (MessageFactory)messageFactory);
        Assert.assertNotNull((Object)((Object)testLogger));
        Assert.assertEquals((Object)messageFactory, (Object)testLogger.getMessageFactory());
        testLogger.debug("{}", new Object[]{Integer.MAX_VALUE});
        Assert.assertEquals((long)1L, (long)testLogger.getEntries().size());
        Assert.assertEquals((Object)" DEBUG 2147483647", (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLogger_Class_StringFormatterMessageFactory() {
        TestLogger testLogger = (TestLogger)LogManager.getLogger(TestStringFormatterMessageFactory.class, (MessageFactory)StringFormatterMessageFactory.INSTANCE);
        Assert.assertNotNull((Object)((Object)testLogger));
        Assert.assertEquals((Object)StringFormatterMessageFactory.INSTANCE, (Object)testLogger.getMessageFactory());
        testLogger.debug("%,d", new Object[]{Integer.MAX_VALUE});
        Assert.assertEquals((long)1L, (long)testLogger.getEntries().size());
        Assert.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLogger_Object_ParameterizedMessageFactory() {
        ParameterizedMessageFactory messageFactory = ParameterizedMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getLogger((Object)new TestParameterizedMessageFactory(), (MessageFactory)messageFactory);
        Assert.assertNotNull((Object)((Object)testLogger));
        Assert.assertEquals((Object)messageFactory, (Object)testLogger.getMessageFactory());
        testLogger.debug("{}", new Object[]{Integer.MAX_VALUE});
        Assert.assertEquals((long)1L, (long)testLogger.getEntries().size());
        Assert.assertEquals((Object)" DEBUG 2147483647", (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLogger_Object_StringFormatterMessageFactory() {
        StringFormatterMessageFactory messageFactory = StringFormatterMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getLogger((Object)new TestStringFormatterMessageFactory(), (MessageFactory)messageFactory);
        Assert.assertNotNull((Object)((Object)testLogger));
        Assert.assertEquals((Object)messageFactory, (Object)testLogger.getMessageFactory());
        testLogger.debug("%,d", new Object[]{Integer.MAX_VALUE});
        Assert.assertEquals((long)1L, (long)testLogger.getEntries().size());
        Assert.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLogger_String_MessageFactoryMismatch() {
        StringFormatterMessageFactory messageFactory = StringFormatterMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getLogger((String)"getLogger_String_MessageFactoryMismatch", (MessageFactory)messageFactory);
        Assert.assertNotNull((Object)((Object)testLogger));
        Assert.assertEquals((Object)messageFactory, (Object)testLogger.getMessageFactory());
        TestLogger testLogger2 = (TestLogger)LogManager.getLogger((String)"getLogger_String_MessageFactoryMismatch", (MessageFactory)ParameterizedMessageFactory.INSTANCE);
        testLogger.debug("%,d", new Object[]{Integer.MAX_VALUE});
        Assert.assertEquals((long)1L, (long)testLogger.getEntries().size());
        Assert.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLogger_String_ParameterizedMessageFactory() {
        ParameterizedMessageFactory messageFactory = ParameterizedMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getLogger((String)"getLogger_String_ParameterizedMessageFactory", (MessageFactory)messageFactory);
        Assert.assertNotNull((Object)((Object)testLogger));
        Assert.assertEquals((Object)messageFactory, (Object)testLogger.getMessageFactory());
        testLogger.debug("{}", new Object[]{Integer.MAX_VALUE});
        Assert.assertEquals((long)1L, (long)testLogger.getEntries().size());
        Assert.assertEquals((Object)" DEBUG 2147483647", (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLogger_String_StringFormatterMessageFactory() {
        StringFormatterMessageFactory messageFactory = StringFormatterMessageFactory.INSTANCE;
        TestLogger testLogger = (TestLogger)LogManager.getLogger((String)"getLogger_String_StringFormatterMessageFactory", (MessageFactory)messageFactory);
        Assert.assertNotNull((Object)((Object)testLogger));
        Assert.assertEquals((Object)messageFactory, (Object)testLogger.getMessageFactory());
        testLogger.debug("%,d", new Object[]{Integer.MAX_VALUE});
        Assert.assertEquals((long)1L, (long)testLogger.getEntries().size());
        Assert.assertEquals((Object)String.format(" DEBUG %,d", Integer.MAX_VALUE), (Object)testLogger.getEntries().get(0));
    }

    @Test
    public void getLoggerByClass() {
        Logger classLogger = LogManager.getLogger(LoggerTest.class);
        Assert.assertNotNull((Object)classLogger);
    }

    @Test
    public void getLoggerByNullClass() {
        Assert.assertNotNull((Object)LogManager.getLogger((Class)null));
    }

    @Test
    public void getLoggerByNullObject() {
        Assert.assertNotNull((Object)LogManager.getLogger((Object)null));
    }

    @Test
    public void getLoggerByNullString() {
        Assert.assertNotNull((Object)LogManager.getLogger((String)null));
    }

    @Test
    public void getLoggerByObject() {
        Logger classLogger = LogManager.getLogger((Object)this);
        Assert.assertNotNull((Object)classLogger);
        Assert.assertEquals((Object)classLogger, (Object)LogManager.getLogger(LoggerTest.class));
    }

    @Test
    public void getRootLogger() {
        Assert.assertNotNull((Object)LogManager.getRootLogger());
        Assert.assertNotNull((Object)LogManager.getLogger((String)""));
        Assert.assertNotNull((Object)LogManager.getLogger((String)""));
        Assert.assertEquals((Object)LogManager.getRootLogger(), (Object)LogManager.getLogger((String)""));
        Assert.assertEquals((Object)LogManager.getRootLogger(), (Object)LogManager.getLogger((String)""));
    }

    @Test
    public void isAllEnabled() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.ALL));
    }

    @Test
    public void isDebugEnabled() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isDebugEnabled());
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.DEBUG));
    }

    @Test
    public void isErrorEnabled() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isErrorEnabled());
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.ERROR));
    }

    @Test
    public void isFatalEnabled() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isFatalEnabled());
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.FATAL));
    }

    @Test
    public void isInfoEnabled() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isInfoEnabled());
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.INFO));
    }

    @Test
    public void isOffEnabled() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.OFF));
    }

    @Test
    public void isTraceEnabled() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isTraceEnabled());
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.TRACE));
    }

    @Test
    public void isWarnEnabled() {
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isWarnEnabled());
        Assert.assertTrue((String)"Incorrect level", (boolean)this.logger.isEnabled(Level.WARN));
    }

    @Test
    public void mdc() {
        ThreadContext.put((String)"TestYear", (String)new Integer(2010).toString());
        this.logger.debug("Debug message");
        ThreadContext.clearMap();
        this.logger.debug("Debug message");
        Assert.assertEquals((long)2L, (long)this.results.size());
        Assert.assertTrue((String)("Incorrect MDC: " + this.results.get(0)), (boolean)this.results.get(0).startsWith(" DEBUG Debug message {TestYear=2010}"));
        Assert.assertTrue((String)("MDC not cleared?: " + this.results.get(1)), (boolean)this.results.get(1).startsWith(" DEBUG Debug message"));
    }

    @Test
    public void printf() {
        this.logger.printf(Level.DEBUG, "Debug message %d", new Object[]{1});
        this.logger.printf(Level.DEBUG, MarkerManager.getMarker((String)"Test"), "Debug message %d", new Object[]{2});
        Assert.assertEquals((long)2L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect message", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)" DEBUG Debug message 1"));
        Assert.assertThat((String)"Incorrect message", (Object)this.results.get(1), (Matcher)CoreMatchers.startsWith((String)"Test DEBUG Debug message 2"));
    }

    @Before
    public void setup() {
        this.results.clear();
    }

    @Test
    public void structuredData() {
        ThreadContext.put((String)"loginId", (String)"JohnDoe");
        ThreadContext.put((String)"ipAddress", (String)"192.168.0.120");
        ThreadContext.put((String)"locale", (String)Locale.US.getDisplayName());
        StructuredDataMessage msg = new StructuredDataMessage("Audit@18060", "Transfer Complete", "Transfer");
        msg.put("ToAccount", "123456");
        msg.put("FromAccount", "123457");
        msg.put("Amount", "200.00");
        this.logger.info(MarkerManager.getMarker((String)"EVENT"), (Message)msg);
        ThreadContext.clearMap();
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect structured data: ", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"EVENT INFO Transfer [Audit@18060 Amount=\"200.00\" FromAccount=\"123457\" ToAccount=\"123456\"] Transfer Complete"));
    }

    @Test
    public void throwing() {
        this.logger.throwing(new IllegalArgumentException("Test Exception"));
        Assert.assertEquals((long)1L, (long)this.results.size());
        Assert.assertThat((String)"Incorrect Throwing", (Object)this.results.get(0), (Matcher)CoreMatchers.startsWith((String)"THROWING[ EXCEPTION ] ERROR throwing java.lang.IllegalArgumentException: Test Exception"));
    }

    private static class TestStringFormatterMessageFactory {
        private TestStringFormatterMessageFactory() {
        }
    }

    private static class TestParameterizedMessageFactory {
        private TestParameterizedMessageFactory() {
        }
    }
}

