/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.resultset.ResultSetReader;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineplugin.spark.common.LineBufferedProcess;
import org.apache.linkis.engineplugin.spark.utils.EngineUtils$;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.LineMetaData;
import org.apache.linkis.storage.resultset.ResultSetReader$;
import org.apache.linkis.storage.utils.StorageUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import scala.util.matching.UnanchoredRegex;

public final class EngineUtils$
implements Logging {
    public static final EngineUtils$ MODULE$;
    private final String user;
    private String org$apache$linkis$engineplugin$spark$utils$EngineUtils$$sparkVersion;
    private Fs fileSystem;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new EngineUtils$();
    }

    private Logger logger$lzycompute() {
        EngineUtils$ engineUtils$ = this;
        synchronized (engineUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    private String user() {
        return this.user;
    }

    public String org$apache$linkis$engineplugin$spark$utils$EngineUtils$$sparkVersion() {
        return this.org$apache$linkis$engineplugin$spark$utils$EngineUtils$$sparkVersion;
    }

    private void org$apache$linkis$engineplugin$spark$utils$EngineUtils$$sparkVersion_$eq(String x$1) {
        this.org$apache$linkis$engineplugin$spark$utils$EngineUtils$$sparkVersion = x$1;
    }

    private Fs fileSystem() {
        return this.fileSystem;
    }

    private void fileSystem_$eq(Fs x$1) {
        this.fileSystem = x$1;
    }

    public String getName() {
        return Sender$.MODULE$.getThisServiceInstance().getInstance();
    }

    public int findAvailPort() {
        ServerSocket socket = new ServerSocket(0);
        return BoxesRunTime.unboxToInt((Object)Utils$.MODULE$.tryFinally((Function0)new Serializable(socket){
            public static final long serialVersionUID = 0L;
            private final ServerSocket socket$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.socket$1.getLocalPort();
            }
            {
                this.socket$1 = socket$1;
            }
        }, (Function0)new Serializable(socket){
            public static final long serialVersionUID = 0L;
            public final ServerSocket socket$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Utils$.MODULE$.tryQuietly((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.findAvailPort.2 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.socket$1.close();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.socket$1 = socket$1;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public String sparkSubmitVersion() {
        block2: {
            void var13_13;
            void var12_12;
            block6: {
                block5: {
                    String version;
                    block3: {
                        void var2_2;
                        block4: {
                            String version2;
                            String string;
                            if (this.org$apache$linkis$engineplugin$spark$utils$EngineUtils$$sparkVersion() != null) break block2;
                            CommonVars sparkVersionVar = CommonVars$.MODULE$.apply("wds.linkis.engine.spark.version", (Object)"");
                            if (!StringUtils.isNotBlank((CharSequence)((String)sparkVersionVar.getValue()).trim())) break block3;
                            String output = ((String)sparkVersionVar.getValue()).trim();
                            UnanchoredRegex regex = new StringOps(Predef$.MODULE$.augmentString("([\\d.]*)")).r().unanchored();
                            Option option = ((Regex)regex).unapplySeq((CharSequence)(string = output));
                            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) break block4;
                            String string2 = version2 = (String)((LinearSeqOptimized)option.get()).apply(0);
                            this.org$apache$linkis$engineplugin$spark$utils$EngineUtils$$sparkVersion_$eq(string2);
                            break block5;
                        }
                        void arg$macro$2 = var2_2;
                        throw new IOException(new StringOps("spark version  is invalid :\n%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$2})));
                    }
                    String sparkSubmit = (String)CommonVars$.MODULE$.apply("wds.linkis.server.spark-submit", (Object)"spark-submit").getValue();
                    ProcessBuilder pb = new ProcessBuilder(sparkSubmit, "--version");
                    pb.redirectErrorStream(true);
                    pb.redirectInput(ProcessBuilder.Redirect.PIPE);
                    LineBufferedProcess process = new LineBufferedProcess(pb.start());
                    int exitCode = process.waitFor();
                    String output = process.inputIterator().mkString("\n");
                    UnanchoredRegex regex = new StringOps(Predef$.MODULE$.augmentString("version ([\\d.]*)")).r().unanchored();
                    String string = output;
                    Option option = ((Regex)regex).unapplySeq((CharSequence)string);
                    if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) break block6;
                    String string3 = version = (String)((LinearSeqOptimized)option.get()).apply(0);
                    this.org$apache$linkis$engineplugin$spark$utils$EngineUtils$$sparkVersion_$eq(string3);
                }
                this.info((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringBuilder().append((Object)"spark version is ").append((Object)EngineUtils$.MODULE$.org$apache$linkis$engineplugin$spark$utils$EngineUtils$$sparkVersion()).toString();
                    }
                });
                return this.org$apache$linkis$engineplugin$spark$utils$EngineUtils$$sparkVersion();
            }
            Integer arg$macro$3 = BoxesRunTime.boxToInteger((int)var12_12);
            void arg$macro$4 = var13_13;
            throw new IOException(new StringOps("Unable to determing spark-submit version [%s]:\n%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$3, arg$macro$4})));
        }
        return this.org$apache$linkis$engineplugin$spark$utils$EngineUtils$$sparkVersion();
    }

    public Option<String> jarOfClass(Class<?> cls) {
        String uriStr;
        URL uri = cls.getResource(new StringBuilder().append((Object)"/").append((Object)cls.getName().replace('.', '/')).append((Object)".class").toString());
        return uri == null ? None$.MODULE$ : ((uriStr = uri.toString()).startsWith("jar:file:") ? new Some((Object)uriStr.substring("jar:file:".length(), uriStr.indexOf("!"))) : None$.MODULE$);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OutputStream createOutputStream(String path) {
        BoxedUnit boxedUnit;
        if (this.fileSystem() == null) {
            EngineUtils$ engineUtils$ = this;
            synchronized (engineUtils$) {
                BoxedUnit boxedUnit2;
                if (this.fileSystem() == null) {
                    this.fileSystem_$eq(FSFactory$.MODULE$.getFs(StorageUtils$.MODULE$.HDFS()));
                    this.fileSystem().init(new HashMap());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit2;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl12 : MonitorExitStatement: MONITOREXIT : engineUtils$
                boxedUnit = boxedUnit3;
                return this.fileSystem().write(new FsPath(path), true);
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.fileSystem().write(new FsPath(path), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream createInputStream(String path) {
        BoxedUnit boxedUnit;
        if (this.fileSystem() == null) {
            EngineUtils$ engineUtils$ = this;
            synchronized (engineUtils$) {
                BoxedUnit boxedUnit2;
                if (this.fileSystem() == null) {
                    this.fileSystem_$eq(FSFactory$.MODULE$.getFs(StorageUtils$.MODULE$.HDFS()));
                    this.fileSystem().init(new HashMap());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit2;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl12 : MonitorExitStatement: MONITOREXIT : engineUtils$
                boxedUnit = boxedUnit3;
                return this.fileSystem().read(new FsPath(path));
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.fileSystem().read(new FsPath(path));
    }

    /*
     * WARNING - void declaration
     */
    public String getResultStrByDolphinTextContent(String dolphinContent) {
        void var3_6;
        String string;
        ResultSetReader resultSetReader = ResultSetReader$.MODULE$.getResultSetReader(dolphinContent);
        MetaData metaData = resultSetReader.getMetaData();
        if (metaData instanceof LineMetaData) {
            StringBuilder sb = new StringBuilder();
            while (resultSetReader.hasNext()) {
                sb.append((Object)resultSetReader.getRecord()).append("\n");
            }
            string = sb.toString();
        } else {
            string = dolphinContent;
        }
        String errorMsg = string;
        return var3_6;
    }

    private EngineUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.user = System.getProperty("user.name");
    }
}

