/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.cs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.cs.client.service.CSTableService;
import org.apache.linkis.cs.common.entity.metadata.CSTable;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineplugin.spark.exception.ExecuteError;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.execution.datasources.csv.DolphinToSpark$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i4A!\u0001\u0002\u0001\u001f\ti1i\u0015+bE2,\u0007+\u0019:tKJT!a\u0001\u0003\u0002\u0005\r\u001c(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0007f]\u001eLg.\u001a9mk\u001eLgN\u0003\u0002\n\u0015\u00051A.\u001b8lSNT!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u0011-A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\u000f\u000e\u0003aQ!!\u0007\u000e\u0002\u000bU$\u0018\u000e\\:\u000b\u0005mA\u0011AB2p[6|g.\u0003\u0002\u001e1\t9Aj\\4hS:<\u0007\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\bF\u0001\"!\t\u0011\u0003!D\u0001\u0003\u0011\u001d!\u0003A1A\u0005\n\u0015\n!\u0001\u001d2\u0016\u0003\u0019\u0002\"a\n\u0018\u000e\u0003!R!!\u000b\u0016\u0002\u000bI,w-\u001a=\u000b\u0005-b\u0013\u0001B;uS2T\u0011!L\u0001\u0005U\u00064\u0018-\u0003\u00020Q\t9\u0001+\u0019;uKJt\u0007BB\u0019\u0001A\u0003%a%A\u0002qE\u0002Bqa\r\u0001C\u0002\u0013%A'\u0001\u0002E\u0005V\tQ\u0007\u0005\u00027s5\tqG\u0003\u00029Y\u0005!A.\u00198h\u0013\tQtG\u0001\u0004TiJLgn\u001a\u0005\u0007y\u0001\u0001\u000b\u0011B\u001b\u0002\u0007\u0011\u0013\u0005\u0005C\u0003?\u0001\u0011%q(\u0001\bhKR\u001c5\u000bV3naR\u000b'\r\\3\u0015\u0005\u0001K\u0005cA\tB\u0007&\u0011!I\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\t\u001es!!E#\n\u0005\u0019\u0013\u0012A\u0002)sK\u0012,g-\u0003\u0002;\u0011*\u0011aI\u0005\u0005\u0006\u0015v\u0002\raQ\u0001\u0005G>$W\rC\u0003M\u0001\u0011\u0005Q*A\u0003qCJ\u001cX\rF\u0003D\u001drkv\fC\u0003P\u0017\u0002\u0007\u0001+A\u000bf]\u001eLg.Z#yK\u000e,Ho\u001c:D_:$X\r\u001f;\u0011\u0005ESV\"\u0001*\u000b\u0005M#\u0016aB3yK\u000e,H/\u001a\u0006\u0003+Z\u000b\u0001\"\u001a=fGV$xN\u001d\u0006\u0003/b\u000b1bY8naV$\u0018\r^5p]*\u0011\u0011\fC\u0001\u000bK:<\u0017N\\3d_:t\u0017BA.S\u0005Y)enZ5oK\u0016CXmY;uS>t7i\u001c8uKb$\b\"\u0002&L\u0001\u0004\u0019\u0005\"\u00020L\u0001\u0004\u0019\u0015!E2p]R,\u0007\u0010^%E-\u0006dW/Z*ue\")\u0001m\u0013a\u0001\u0007\u0006Yan\u001c3f\u001d\u0006lWm\u0015;s\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0003)9W\r^\"T)\u0006\u0014G.\u001a\u000b\u0005I:\u0004\u0018\u000f\u0005\u0002fY6\taM\u0003\u0002hQ\u0006AQ.\u001a;bI\u0006$\u0018M\u0003\u0002jU\u00061QM\u001c;jifT!aG6\u000b\u0005\rA\u0011BA7g\u0005\u001d\u00195\u000bV1cY\u0016DQa\\1A\u0002\r\u000b1bY:UK6\u0004H+\u00192mK\")a,\u0019a\u0001\u0007\")\u0001-\u0019a\u0001\u0007\")1\u000f\u0001C\u0001i\u0006\t\"/Z4jgR,'\u000fV3naR\u000b'\r\\3\u0015\u0005UD\bCA\tw\u0013\t9(C\u0001\u0003V]&$\b\"B=s\u0001\u0004!\u0017aB2t)\u0006\u0014G.\u001a")
public class CSTableParser
implements Logging {
    private final Pattern pb;
    private final String DB;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        CSTableParser cSTableParser = this;
        synchronized (cSTableParser) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    private Pattern pb() {
        return this.pb;
    }

    private String DB() {
        return this.DB;
    }

    private String[] getCSTempTable(String code) {
        ArrayBuffer bmlResourceNames = new ArrayBuffer();
        Matcher mb = this.pb().matcher(code);
        while (mb.find()) {
            bmlResourceNames.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{mb.group().trim()}));
        }
        return (String[])bmlResourceNames.toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public String parse(EngineExecutionContext engineExecutorContext, String code, String contextIDValueStr, String nodeNameStr) {
        String[] csTempTables = this.getCSTempTable(code);
        ArrayBuffer parsedTables = new ArrayBuffer();
        Predef$.MODULE$.refArrayOps((Object[])csTempTables).foreach((Function1)new Serializable(this, contextIDValueStr, nodeNameStr, parsedTables){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSTableParser $outer;
            private final String contextIDValueStr$1;
            private final String nodeNameStr$1;
            private final ArrayBuffer parsedTables$1;

            public final void apply(String csTempTable) {
                CSTable table = this.$outer.getCSTable(csTempTable, this.contextIDValueStr$1, this.nodeNameStr$1);
                if (table == null) {
                    throw new ExecuteError(40007, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The csTable that name is ", " not found in cs"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{csTempTable})));
                }
                this.$outer.registerTempTable(table);
                this.parsedTables$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{csTempTable}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.contextIDValueStr$1 = contextIDValueStr$1;
                this.nodeNameStr$1 = nodeNameStr$1;
                this.parsedTables$1 = parsedTables$1;
            }
        });
        return StringUtils.replaceEach((String)code, (String[])csTempTables, (String[])((String[])parsedTables.toArray(ClassTag$.MODULE$.apply(String.class))));
    }

    public CSTable getCSTable(String csTempTable, String contextIDValueStr, String nodeNameStr) {
        return CSTableService.getInstance().getUpstreamSuitableTable(contextIDValueStr, nodeNameStr, csTempTable);
    }

    public void registerTempTable(CSTable csTable) {
        SparkSession spark = SparkSession$.MODULE$.builder().enableHiveSupport().getOrCreate();
        this.info((Function0<String>)new Serializable(this, csTable){
            public static final long serialVersionUID = 0L;
            private final CSTable csTable$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start to create  tempView to sparkSession viewName(", ") location(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.csTable$1.getName(), this.csTable$1.getLocation()}));
            }
            {
                this.csTable$1 = csTable$1;
            }
        });
        DolphinToSpark$.MODULE$.createTempView(spark, csTable.getName(), csTable.getLocation(), true);
        this.info((Function0<String>)new Serializable(this, csTable){
            public static final long serialVersionUID = 0L;
            private final CSTable csTable$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished to create  tempView to sparkSession viewName(", ") location(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.csTable$1.getName(), this.csTable$1.getLocation()}));
            }
            {
                this.csTable$1 = csTable$1;
            }
        });
    }

    public CSTableParser() {
        Logging.class.$init$((Logging)this);
        this.pb = Pattern.compile("cs_tmp_[^\\s\";'()]+[$\\s]{0,1}", 2);
        this.DB = "default.";
    }
}

