/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.Interpreter;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.apache.linkis.common.conf.CommonVars$;
import org.apache.linkis.engineplugin.spark.Interpreter.Interpreter;
import org.apache.linkis.engineplugin.spark.Interpreter.PythonInterpreter;
import org.apache.linkis.engineplugin.spark.Interpreter.SQLSession$;
import org.apache.linkis.engineplugin.spark.config.SparkConfiguration$;
import org.apache.linkis.engineplugin.spark.utils.EngineUtils$;
import org.apache.spark.SparkContext;
import py4j.GatewayServer;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;

public final class PythonInterpreter$ {
    public static final PythonInterpreter$ MODULE$;

    static {
        new PythonInterpreter$();
    }

    public Interpreter create() {
        String pythonExec = (String)CommonVars$.MODULE$.apply("PYSPARK_DRIVER_PYTHON", (Object)"python").getValue();
        GatewayServer gatewayServer = new GatewayServer((Object)SQLSession$.MODULE$, 0);
        gatewayServer.start();
        ProcessBuilder builder = new ProcessBuilder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.refArrayOps((Object[])new String[]{pythonExec, this.createFakeShell().toString()}).toList()).asJava());
        Map<String, String> env = builder.environment();
        env.put("PYTHONPATH", this.pythonPath());
        env.put("PYTHONUNBUFFERED", "YES");
        env.put("PYSPARK_GATEWAY_PORT", String.valueOf(BoxesRunTime.boxToInteger((int)gatewayServer.getListeningPort())));
        env.put("SPARK_HOME", (String)SparkConfiguration$.MODULE$.SPARK_HOME().getValue());
        Process process = builder.start();
        return new PythonInterpreter(process, gatewayServer);
    }

    public String pythonPath() {
        ArrayBuffer pythonPath2 = new ArrayBuffer();
        String pythonHomePath = new File((String)SparkConfiguration$.MODULE$.SPARK_HOME().getValue(), "python").getPath();
        File pythonParentPath = new File(pythonHomePath, "lib");
        pythonPath2.$plus$eq((Object)pythonHomePath);
        Predef$.MODULE$.refArrayOps((Object[])pythonParentPath.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".zip");
            }
        })).foreach((Function1)new Serializable(pythonPath2){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer pythonPath$1;

            public final ArrayBuffer<String> apply(File f) {
                return this.pythonPath$1.$plus$eq((Object)f.getPath());
            }
            {
                this.pythonPath$1 = pythonPath$1;
            }
        });
        EngineUtils$.MODULE$.jarOfClass(SparkContext.class).foreach((Function1)new Serializable(pythonPath2){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer pythonPath$1;

            public final ArrayBuffer<String> apply(String x$1) {
                return this.pythonPath$1.$plus$eq((Object)x$1);
            }
            {
                this.pythonPath$1 = pythonPath$1;
            }
        });
        return pythonPath2.mkString(File.pathSeparator);
    }

    public File createFakeShell() {
        return this.createFakeShell("python/fake_shell.py", this.createFakeShell$default$2());
    }

    public File createFakeShell(String script, String fileType) {
        InputStream source = this.getClass().getClassLoader().getResourceAsStream(script);
        File file = Files.createTempFile("", fileType, new FileAttribute[0]).toFile();
        file.deleteOnExit();
        FileOutputStream sink = new FileOutputStream(file);
        byte[] buf = new byte[1024];
        int n = source.read(buf);
        while (n > 0) {
            sink.write(buf, 0, n);
            n = source.read(buf);
        }
        source.close();
        sink.close();
        return file;
    }

    public String createFakeShell$default$2() {
        return ".py";
    }

    /*
     * WARNING - void declaration
     */
    private File createFakePySpark() {
        void var2_2;
        InputStream source = this.getClass().getClassLoader().getResourceAsStream("fake_pyspark.sh");
        File file = Files.createTempFile("", "", new FileAttribute[0]).toFile();
        file.deleteOnExit();
        file.setExecutable(true);
        FileOutputStream sink = new FileOutputStream(file);
        byte[] buf = new byte[1024];
        int n = source.read(buf);
        while (n > 0) {
            sink.write(buf, 0, n);
            n = source.read(buf);
        }
        source.close();
        sink.close();
        return var2_2;
    }

    private PythonInterpreter$() {
        MODULE$ = this;
    }
}

