/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kyuubi.shade.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kyuubi.shade.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.kyuubi.shade.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.ranger.plugin.model.RangerBaseModelObject;
import org.apache.ranger.plugin.model.RangerPrincipal;
import org.apache.ranger.plugin.model.RangerSecurityZone;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RangerSecurityZoneV2
extends RangerBaseModelObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private Map<String, RangerSecurityZoneServiceV2> services;
    private List<String> tagServices;
    private List<RangerPrincipal> admins;
    private List<RangerPrincipal> auditors;

    public RangerSecurityZoneV2() {
        this(null, null, null, null, null, null);
    }

    public RangerSecurityZoneV2(String name, String description, Map<String, RangerSecurityZoneServiceV2> services, List<String> tagServices, List<RangerPrincipal> admins, List<RangerPrincipal> auditors) {
        this.setName(name);
        this.setDescription(description);
        this.setServices(services);
        this.setTagServices(tagServices);
        this.setAdmins(admins);
        this.setAuditors(auditors);
    }

    public RangerSecurityZoneV2(RangerSecurityZone other) {
        this.setId(other.getId());
        this.setGuid(other.getGuid());
        this.setIsEnabled(other.getIsEnabled());
        this.setCreatedBy(other.getCreatedBy());
        this.setUpdatedBy(other.getUpdatedBy());
        this.setCreateTime(other.getCreateTime());
        this.setUpdateTime(other.getUpdateTime());
        this.setVersion(other.getVersion());
        this.setName(other.getName());
        this.setDescription(other.getDescription());
        this.setTagServices((List<String>)(other.getTagServices() != null ? new ArrayList<String>(other.getTagServices()) : new ArrayList()));
        this.setAdmins(this.toPrincipals(other.getAdminUsers(), other.getAdminUserGroups(), other.getAdminRoles()));
        this.setAuditors(this.toPrincipals(other.getAuditUsers(), other.getAuditUserGroups(), other.getAuditRoles()));
        this.services = new HashMap<String, RangerSecurityZoneServiceV2>();
        if (other.getServices() != null) {
            for (Map.Entry<String, RangerSecurityZone.RangerSecurityZoneService> entry : other.getServices().entrySet()) {
                this.services.put(entry.getKey(), new RangerSecurityZoneServiceV2(entry.getValue()));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, RangerSecurityZoneServiceV2> getServices() {
        return this.services;
    }

    public void setServices(Map<String, RangerSecurityZoneServiceV2> services) {
        this.services = services == null ? new HashMap() : services;
    }

    public List<String> getTagServices() {
        return this.tagServices;
    }

    public void setTagServices(List<String> tagServices) {
        this.tagServices = tagServices != null ? tagServices : new ArrayList();
    }

    public List<RangerPrincipal> getAdmins() {
        return this.admins;
    }

    public void setAdmins(List<RangerPrincipal> admins) {
        this.admins = admins == null ? new ArrayList() : admins;
    }

    public List<RangerPrincipal> getAuditors() {
        return this.auditors;
    }

    public void setAuditors(List<RangerPrincipal> auditors) {
        this.auditors = auditors == null ? new ArrayList() : auditors;
    }

    public RangerSecurityZone toV1() {
        RangerSecurityZone ret = new RangerSecurityZone();
        ret.setId(this.getId());
        ret.setGuid(this.getGuid());
        ret.setIsEnabled(this.getIsEnabled());
        ret.setCreatedBy(this.getCreatedBy());
        ret.setUpdatedBy(this.getUpdatedBy());
        ret.setCreateTime(this.getCreateTime());
        ret.setUpdateTime(this.getUpdateTime());
        ret.setVersion(this.getVersion());
        ret.setName(this.name);
        ret.setDescription(this.description);
        if (this.services != null) {
            for (Map.Entry<String, RangerSecurityZoneServiceV2> entry : this.services.entrySet()) {
                ret.getServices().put(entry.getKey(), entry.getValue().toV1());
            }
        }
        if (this.tagServices != null) {
            ret.getTagServices().addAll(this.tagServices);
        }
        this.fromPrincipals(this.admins, ret.getAdminUsers(), ret.getAdminUserGroups(), ret.getAdminRoles());
        this.fromPrincipals(this.auditors, ret.getAuditUsers(), ret.getAuditUserGroups(), ret.getAuditRoles());
        return ret;
    }

    @Override
    public String toString() {
        return "{name=" + this.name + ", description=" + this.description + ", services=" + this.services + ", tagServices=" + this.tagServices + ", admins=" + this.admins + ", auditors=" + this.auditors + "}";
    }

    private void fromPrincipals(List<RangerPrincipal> principals, List<String> users, List<String> groups, List<String> roles) {
        if (principals != null) {
            for (RangerPrincipal principal : principals) {
                if (principal.getType() == RangerPrincipal.PrincipalType.USER) {
                    users.add(principal.getName());
                    continue;
                }
                if (principal.getType() == RangerPrincipal.PrincipalType.GROUP) {
                    groups.add(principal.getName());
                    continue;
                }
                if (principal.getType() != RangerPrincipal.PrincipalType.ROLE) continue;
                roles.add(principal.getName());
            }
        }
    }

    private List<RangerPrincipal> toPrincipals(List<String> users, List<String> groups, List<String> roles) {
        ArrayList<RangerPrincipal> ret = new ArrayList<RangerPrincipal>();
        if (users != null) {
            for (String name : users) {
                ret.add(new RangerPrincipal(RangerPrincipal.PrincipalType.USER, name));
            }
        }
        if (groups != null) {
            for (String name : groups) {
                ret.add(new RangerPrincipal(RangerPrincipal.PrincipalType.GROUP, name));
            }
        }
        if (roles != null) {
            for (String name : roles) {
                ret.add(new RangerPrincipal(RangerPrincipal.PrincipalType.ROLE, name));
            }
        }
        return ret;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RangerSecurityZoneChangeRequest
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String name;
        private String description;
        private Map<String, RangerSecurityZoneServiceV2> resourcesToUpdate;
        private Map<String, RangerSecurityZoneServiceV2> resourcesToRemove;
        private List<String> tagServicesToAdd;
        private List<String> tagServicesToRemove;
        private List<RangerPrincipal> adminsToAdd;
        private List<RangerPrincipal> adminsToRemove;
        private List<RangerPrincipal> auditorsToAdd;
        private List<RangerPrincipal> auditorsToRemove;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Map<String, RangerSecurityZoneServiceV2> getResourcesToUpdate() {
            return this.resourcesToUpdate;
        }

        public void setResourcesToUpdate(Map<String, RangerSecurityZoneServiceV2> resourcesToUpdate) {
            this.resourcesToUpdate = resourcesToUpdate;
        }

        public Map<String, RangerSecurityZoneServiceV2> getResourcesToRemove() {
            return this.resourcesToRemove;
        }

        public void setResourcesToRemove(Map<String, RangerSecurityZoneServiceV2> resourcesToRemove) {
            this.resourcesToRemove = resourcesToRemove;
        }

        public List<String> getTagServicesToAdd() {
            return this.tagServicesToAdd;
        }

        public void setTagServicesToAdd(List<String> tagServicesToAdd) {
            this.tagServicesToAdd = tagServicesToAdd;
        }

        public List<String> getTagServicesToRemove() {
            return this.tagServicesToRemove;
        }

        public void setTagServicesToRemove(List<String> tagServicesToRemove) {
            this.tagServicesToRemove = tagServicesToRemove;
        }

        public List<RangerPrincipal> getAdminsToAdd() {
            return this.adminsToAdd;
        }

        public void setAdminsToAdd(List<RangerPrincipal> adminsToAdd) {
            this.adminsToAdd = adminsToAdd;
        }

        public List<RangerPrincipal> getAdminsToRemove() {
            return this.adminsToRemove;
        }

        public void setAdminsToRemove(List<RangerPrincipal> adminsToRemove) {
            this.adminsToRemove = adminsToRemove;
        }

        public List<RangerPrincipal> getAuditorsToAdd() {
            return this.auditorsToAdd;
        }

        public void setAuditorsToAdd(List<RangerPrincipal> auditorsToAdd) {
            this.auditorsToAdd = auditorsToAdd;
        }

        public List<RangerPrincipal> getAuditorsToRemove() {
            return this.auditorsToRemove;
        }

        public void setAuditorsToRemove(List<RangerPrincipal> auditorsToRemove) {
            this.auditorsToRemove = auditorsToRemove;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RangerSecurityZoneResource
    extends RangerSecurityZoneResourceBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Map<String, List<String>> resource;

        public RangerSecurityZoneResource() {
            this(null, null);
        }

        public RangerSecurityZoneResource(Map<String, List<String>> resource) {
            this(resource, null);
        }

        public RangerSecurityZoneResource(Map<String, List<String>> resource, RangerSecurityZoneResourceBase baseObj) {
            super(baseObj);
            this.setResource(resource);
        }

        public Map<String, List<String>> getResource() {
            return this.resource;
        }

        public void setResource(Map<String, List<String>> resource) {
            this.resource = resource == null ? new HashMap() : resource;
        }

        @Override
        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("{resource=");
            super.toString(sb);
            if (this.resource != null) {
                for (Map.Entry<String, List<String>> entry : this.resource.entrySet()) {
                    sb.append("{resource-def-name=").append(entry.getKey()).append(", values=").append(entry.getValue()).append("} ");
                }
            }
            sb.append("}");
            return sb;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RangerSecurityZoneResourceBase
    implements Serializable {
        private Long id;
        private String createdBy;
        private String updatedBy;
        private Date createTime;
        private Date updateTime;

        public RangerSecurityZoneResourceBase() {
        }

        public RangerSecurityZoneResourceBase(RangerSecurityZoneResourceBase other) {
            if (other != null) {
                this.setId(other.getId());
                this.setCreatedBy(other.getCreatedBy());
                this.setCreateTime(other.getCreateTime());
                this.setUpdatedBy(other.getUpdatedBy());
                this.setUpdateTime(other.getUpdateTime());
            }
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getCreatedBy() {
            return this.createdBy;
        }

        public void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public String getUpdatedBy() {
            return this.updatedBy;
        }

        public void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        public Date getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Date createTime) {
            this.createTime = createTime;
        }

        public Date getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(Date updateTime) {
            this.updateTime = updateTime;
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("{id=").append(this.id).append(", createdBy=").append(this.createdBy).append(", createTime=").append(this.createTime).append(", updatedBy=").append(this.updatedBy).append(", updateTime=").append(this.updateTime).append("}");
            return sb;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RangerSecurityZoneServiceV2
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<RangerSecurityZoneResource> resources;

        public RangerSecurityZoneServiceV2() {
            this((List<RangerSecurityZoneResource>)null);
        }

        public RangerSecurityZoneServiceV2(List<RangerSecurityZoneResource> resources) {
            this.setResources(resources);
        }

        public RangerSecurityZoneServiceV2(RangerSecurityZone.RangerSecurityZoneService other) {
            this.resources = new ArrayList<RangerSecurityZoneResource>();
            if (other != null && other.getResources() != null) {
                for (int i = 0; i < other.getResources().size(); ++i) {
                    RangerSecurityZoneResource resource = this.getResourceAt(other, i);
                    if (resource == null) continue;
                    this.resources.add(resource);
                }
            }
        }

        public List<RangerSecurityZoneResource> getResources() {
            return this.resources;
        }

        public void setResources(List<RangerSecurityZoneResource> resources) {
            this.resources = resources == null ? new ArrayList() : resources;
        }

        public RangerSecurityZone.RangerSecurityZoneService toV1() {
            RangerSecurityZone.RangerSecurityZoneService ret = new RangerSecurityZone.RangerSecurityZoneService();
            if (this.resources != null) {
                for (RangerSecurityZoneResource resource : this.resources) {
                    ret.getResources().add((HashMap)resource.getResource());
                    ret.getResourcesBaseInfo().add(new RangerSecurityZoneResourceBase(resource));
                }
            }
            return ret;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{resources=[");
            if (this.resources != null) {
                for (RangerSecurityZoneResource resource : this.resources) {
                    if (resource == null) continue;
                    resource.toString(sb).append(" ");
                }
            }
            sb.append("]}");
            return sb.toString();
        }

        private RangerSecurityZoneResource getResourceAt(RangerSecurityZone.RangerSecurityZoneService zoneService, int idx) {
            Map resource = zoneService.getResources() != null && zoneService.getResources().size() > idx ? (Map)zoneService.getResources().get(idx) : null;
            RangerSecurityZoneResourceBase baseInfo = zoneService.getResourcesBaseInfo() != null && zoneService.getResourcesBaseInfo().size() > idx ? zoneService.getResourcesBaseInfo().get(idx) : null;
            return resource != null ? new RangerSecurityZoneResource(resource, baseInfo) : null;
        }
    }
}

