/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.zookeeper.server;

import java.net.InetSocketAddress;
import org.apache.kyuubi.shaded.zookeeper.server.ZooKeeperServer;
import org.apache.kyuubi.shaded.zookeeper.server.ZooKeeperServerBean;
import org.apache.kyuubi.shaded.zookeeper.server.quorum.Observer;
import org.apache.kyuubi.shaded.zookeeper.server.quorum.ObserverMXBean;
import org.apache.kyuubi.shaded.zookeeper.server.quorum.QuorumPeer;

public class ObserverBean
extends ZooKeeperServerBean
implements ObserverMXBean {
    private Observer observer;

    public ObserverBean(Observer observer, ZooKeeperServer zks) {
        super(zks);
        this.observer = observer;
    }

    @Override
    public String getName() {
        return "Observer";
    }

    @Override
    public int getPendingRevalidationCount() {
        return this.observer.getPendingRevalidationsCount();
    }

    @Override
    public String getQuorumAddress() {
        return this.observer.getSocket().toString();
    }

    @Override
    public String getLearnerMaster() {
        QuorumPeer.QuorumServer learnerMaster = this.observer.getCurrentLearnerMaster();
        if (learnerMaster == null || learnerMaster.addr.isEmpty()) {
            return "Unknown";
        }
        InetSocketAddress address = learnerMaster.addr.getReachableOrOne();
        return address.getAddress().getHostAddress() + ":" + address.getPort();
    }

    @Override
    public void setLearnerMaster(String learnerMaster) {
        if (!this.observer.setLearnerMaster(learnerMaster)) {
            throw new IllegalArgumentException("Not a valid learner master");
        }
    }
}

