/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.zookeeper.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.kyuubi.shaded.zookeeper.KeeperException;
import org.apache.kyuubi.shaded.zookeeper.cli.CliCommand;
import org.apache.kyuubi.shaded.zookeeper.cli.CliException;
import org.apache.kyuubi.shaded.zookeeper.cli.CliParseException;
import org.apache.kyuubi.shaded.zookeeper.cli.CliWrapperException;
import org.apache.kyuubi.shaded.zookeeper.cli.MalformedCommandException;
import org.apache.kyuubi.shaded.zookeeper.cli.MalformedPathException;

public class GetAllChildrenNumberCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;

    public GetAllChildrenNumberCommand() {
        super("getAllChildrenNumber", "path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        CommandLine cl;
        DefaultParser parser = new DefaultParser();
        try {
            cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = cl.getArgs();
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        if (this.args.length < 2) {
            throw new MalformedCommandException(this.getUsageStr());
        }
        try {
            String path = this.args[1];
            int allChildrenNumber = this.zk.getAllChildrenNumber(path);
            this.out.println(allChildrenNumber);
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (InterruptedException | KeeperException ex) {
            throw new CliWrapperException(ex);
        }
        return false;
    }
}

