/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.zookeeper.audit;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.kyuubi.shaded.jute.Record;
import org.apache.kyuubi.shaded.zookeeper.CreateMode;
import org.apache.kyuubi.shaded.zookeeper.KeeperException;
import org.apache.kyuubi.shaded.zookeeper.MultiOperationRecord;
import org.apache.kyuubi.shaded.zookeeper.Op;
import org.apache.kyuubi.shaded.zookeeper.ZKUtil;
import org.apache.kyuubi.shaded.zookeeper.audit.AuditEvent;
import org.apache.kyuubi.shaded.zookeeper.audit.ZKAuditProvider;
import org.apache.kyuubi.shaded.zookeeper.proto.CreateRequest;
import org.apache.kyuubi.shaded.zookeeper.proto.DeleteRequest;
import org.apache.kyuubi.shaded.zookeeper.proto.SetACLRequest;
import org.apache.kyuubi.shaded.zookeeper.proto.SetDataRequest;
import org.apache.kyuubi.shaded.zookeeper.server.ByteBufferInputStream;
import org.apache.kyuubi.shaded.zookeeper.server.DataTree;
import org.apache.kyuubi.shaded.zookeeper.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuditHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AuditHelper.class);

    public static void addAuditLog(Request request, DataTree.ProcessTxnResult rc) {
        AuditHelper.addAuditLog(request, rc, false);
    }

    public static void addAuditLog(Request request, DataTree.ProcessTxnResult txnResult, boolean failedTxn) {
        if (!ZKAuditProvider.isAuditEnabled()) {
            return;
        }
        String op = null;
        String path = txnResult.path;
        String acls = null;
        String createMode = null;
        try {
            switch (request.type) {
                case 1: 
                case 15: 
                case 19: {
                    op = "create";
                    if (failedTxn) {
                        CreateRequest createRequest = new CreateRequest();
                        AuditHelper.deserialize(request, createRequest);
                        path = createRequest.getPath();
                        createMode = AuditHelper.getCreateMode(createRequest);
                        break;
                    }
                    createMode = AuditHelper.getCreateMode(request);
                    break;
                }
                case 2: 
                case 20: {
                    op = "delete";
                    if (!failedTxn) break;
                    DeleteRequest deleteRequest = new DeleteRequest();
                    AuditHelper.deserialize(request, deleteRequest);
                    path = deleteRequest.getPath();
                    break;
                }
                case 5: {
                    op = "setData";
                    if (!failedTxn) break;
                    SetDataRequest setDataRequest = new SetDataRequest();
                    AuditHelper.deserialize(request, setDataRequest);
                    path = setDataRequest.getPath();
                    break;
                }
                case 7: {
                    op = "setAcl";
                    if (failedTxn) {
                        SetACLRequest setACLRequest = new SetACLRequest();
                        AuditHelper.deserialize(request, setACLRequest);
                        path = setACLRequest.getPath();
                        acls = ZKUtil.aclToString(setACLRequest.getAcl());
                        break;
                    }
                    acls = AuditHelper.getACLs(request);
                    break;
                }
                case 14: {
                    if (failedTxn) {
                        op = "multiOperation";
                        break;
                    }
                    AuditHelper.logMultiOperation(request, txnResult);
                    return;
                }
                case 16: {
                    op = "reconfig";
                    break;
                }
                default: {
                    return;
                }
            }
            AuditEvent.Result result = AuditHelper.getResult(txnResult, failedTxn);
            AuditHelper.log(request, path, op, acls, createMode, result);
        }
        catch (Throwable e) {
            LOG.error("Failed to audit log request {}", (Object)request.type, (Object)e);
        }
    }

    private static void deserialize(Request request, Record record) throws IOException {
        request.request.rewind();
        ByteBufferInputStream.byteBuffer2Record(request.request.slice(), record);
    }

    private static AuditEvent.Result getResult(DataTree.ProcessTxnResult rc, boolean failedTxn) {
        if (failedTxn) {
            return AuditEvent.Result.FAILURE;
        }
        return rc.err == KeeperException.Code.OK.intValue() ? AuditEvent.Result.SUCCESS : AuditEvent.Result.FAILURE;
    }

    private static void logMultiOperation(Request request, DataTree.ProcessTxnResult rc) throws IOException, KeeperException {
        Map<String, String> createModes = AuditHelper.getCreateModes(request);
        boolean multiFailed = false;
        for (DataTree.ProcessTxnResult subTxnResult : rc.multiResult) {
            switch (subTxnResult.type) {
                case 1: 
                case 15: 
                case 19: 
                case 21: {
                    AuditHelper.log(request, subTxnResult.path, "create", null, createModes.get(subTxnResult.path), AuditEvent.Result.SUCCESS);
                    break;
                }
                case 2: 
                case 20: {
                    AuditHelper.log(request, subTxnResult.path, "delete", null, null, AuditEvent.Result.SUCCESS);
                    break;
                }
                case 5: {
                    AuditHelper.log(request, subTxnResult.path, "setData", null, null, AuditEvent.Result.SUCCESS);
                    break;
                }
                case -1: {
                    multiFailed = true;
                    break;
                }
            }
        }
        if (multiFailed) {
            AuditHelper.log(request, rc.path, "multiOperation", null, null, AuditEvent.Result.FAILURE);
        }
    }

    private static void log(Request request, String path, String op, String acls, String createMode, AuditEvent.Result result) {
        AuditHelper.log(request.getUsers(), op, path, acls, createMode, request.cnxn.getSessionIdHex(), request.cnxn.getHostAddress(), result);
    }

    private static void log(String user, String operation, String znode, String acl, String createMode, String session, String ip, AuditEvent.Result result) {
        ZKAuditProvider.log(user, operation, znode, acl, createMode, session, ip, result);
    }

    private static String getACLs(Request request) throws IOException {
        SetACLRequest setACLRequest = new SetACLRequest();
        AuditHelper.deserialize(request, setACLRequest);
        return ZKUtil.aclToString(setACLRequest.getAcl());
    }

    private static String getCreateMode(Request request) throws IOException, KeeperException {
        CreateRequest createRequest = new CreateRequest();
        AuditHelper.deserialize(request, createRequest);
        return AuditHelper.getCreateMode(createRequest);
    }

    private static String getCreateMode(CreateRequest createRequest) throws KeeperException {
        return CreateMode.fromFlag(createRequest.getFlags()).toString().toLowerCase();
    }

    private static Map<String, String> getCreateModes(Request request) throws IOException, KeeperException {
        HashMap<String, String> createModes = new HashMap<String, String>();
        if (!ZKAuditProvider.isAuditEnabled()) {
            return createModes;
        }
        MultiOperationRecord multiRequest = new MultiOperationRecord();
        AuditHelper.deserialize(request, multiRequest);
        for (Op op : multiRequest) {
            if (op.getType() != 1 && op.getType() != 15 && op.getType() != 19) continue;
            CreateRequest requestRecord = (CreateRequest)op.toRequestRecord();
            createModes.put(requestRecord.getPath(), AuditHelper.getCreateMode(requestRecord));
        }
        return createModes;
    }
}

