/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.google.common.collect;

import java.util.Queue;
import javax.annotation.CheckForNull;
import org.apache.kyuubi.shaded.google.common.annotations.GwtCompatible;
import org.apache.kyuubi.shaded.google.common.base.Preconditions;
import org.apache.kyuubi.shaded.google.common.collect.AbstractIterator;
import org.apache.kyuubi.shaded.google.common.collect.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class ConsumingQueueIterator<T>
extends AbstractIterator<T> {
    private final Queue<T> queue;

    ConsumingQueueIterator(Queue<T> queue) {
        this.queue = Preconditions.checkNotNull(queue);
    }

    @Override
    @CheckForNull
    public T computeNext() {
        if (this.queue.isEmpty()) {
            return this.endOfData();
        }
        return this.queue.remove();
    }
}

