/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.curator.framework.recipes.cache;

import org.apache.kyuubi.shaded.curator.framework.CuratorFramework;
import org.apache.kyuubi.shaded.curator.framework.recipes.cache.ChildData;
import org.apache.kyuubi.shaded.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.kyuubi.shaded.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.kyuubi.shaded.curator.framework.recipes.cache.TreeCacheListener;

class TreeCacheListenerWrapper
implements CuratorCacheListener {
    private final CuratorFramework client;
    private final TreeCacheListener listener;

    TreeCacheListenerWrapper(CuratorFramework client, TreeCacheListener listener) {
        this.client = client;
        this.listener = listener;
    }

    @Override
    public void event(CuratorCacheListener.Type type, ChildData oldData, ChildData data) {
        switch (type) {
            case NODE_CREATED: {
                this.sendEvent(data, null, TreeCacheEvent.Type.NODE_ADDED);
                break;
            }
            case NODE_CHANGED: {
                this.sendEvent(data, oldData, TreeCacheEvent.Type.NODE_UPDATED);
                break;
            }
            case NODE_DELETED: {
                this.sendEvent(oldData, null, TreeCacheEvent.Type.NODE_REMOVED);
            }
        }
    }

    @Override
    public void initialized() {
        this.sendEvent(null, null, TreeCacheEvent.Type.INITIALIZED);
    }

    private void sendEvent(ChildData node, ChildData oldNode, TreeCacheEvent.Type type) {
        TreeCacheEvent event = new TreeCacheEvent(type, node, oldNode);
        try {
            this.listener.childEvent(this.client, event);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

