/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.source.kafka;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.stream.core.source.ISourcePosition;

public class KafkaPosition
implements ISourcePosition {
    private Map<Integer, Long> partitionOffsetMap = Maps.newHashMap();

    public KafkaPosition() {
    }

    public KafkaPosition(Map<Integer, Long> partitionOffsetMap) {
        this.partitionOffsetMap = partitionOffsetMap;
    }

    public void update(ISourcePosition.IPartitionPosition point) {
        KafkaPartitionPosition kafkaPartitionPosition = (KafkaPartitionPosition)point;
        this.partitionOffsetMap.put(kafkaPartitionPosition.partition, kafkaPartitionPosition.offset);
    }

    public void updateWhenPartitionNotExist(ISourcePosition.IPartitionPosition partPosition) {
        KafkaPartitionPosition kafkaPartitionPosition = (KafkaPartitionPosition)partPosition;
        if (!this.partitionOffsetMap.containsKey(kafkaPartitionPosition.partition)) {
            this.partitionOffsetMap.put(kafkaPartitionPosition.partition, kafkaPartitionPosition.offset);
        }
    }

    public ISourcePosition advance() {
        HashMap newOffsetMap = Maps.newHashMap();
        for (Map.Entry<Integer, Long> partitionOffsetEntry : this.partitionOffsetMap.entrySet()) {
            newOffsetMap.put(partitionOffsetEntry.getKey(), partitionOffsetEntry.getValue() + 1L);
        }
        return new KafkaPosition(newOffsetMap);
    }

    public Map<Integer, ISourcePosition.IPartitionPosition> getPartitionPositions() {
        return Maps.transformEntries(this.partitionOffsetMap, (Maps.EntryTransformer)new Maps.EntryTransformer<Integer, Long, ISourcePosition.IPartitionPosition>(){

            public ISourcePosition.IPartitionPosition transformEntry(@Nullable Integer key, @Nullable Long value) {
                return new KafkaPartitionPosition(key, value);
            }
        });
    }

    public Map<Integer, Long> getPartitionOffsets() {
        return this.partitionOffsetMap;
    }

    public String toString() {
        return "KafkaPosition{partitionOffsetMap=" + this.partitionOffsetMap + '}';
    }

    public void copy(ISourcePosition other) {
        this.partitionOffsetMap = new HashMap<Integer, Long>(((KafkaPosition)other).partitionOffsetMap);
    }

    public static class KafkaPartitionPosition
    implements ISourcePosition.IPartitionPosition {
        public int partition;
        public long offset;

        public KafkaPartitionPosition(int partition, long offset) {
            this.partition = partition;
            this.offset = offset;
        }

        public int getPartition() {
            return this.partition;
        }

        public int compareTo(ISourcePosition.IPartitionPosition o) {
            KafkaPartitionPosition kafkaPartPos = (KafkaPartitionPosition)o;
            return Long.compare(this.offset, kafkaPartPos.offset);
        }
    }
}

