/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.source.kafka;

import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.stream.core.source.MessageParserInfo;
import org.apache.kylin.stream.source.kafka.AbstractTimeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeParser
extends AbstractTimeParser {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeParser.class);
    private String tsPattern = null;
    private FastDateFormat formatter = null;

    public DateTimeParser(MessageParserInfo parserInfo) {
        super(parserInfo);
        this.tsPattern = parserInfo.getTsPattern();
        try {
            this.formatter = DateFormat.getDateFormat((String)this.tsPattern);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Invalid tsPattern: '" + this.tsPattern + "'.");
        }
    }

    @Override
    public long parseTime(String timeStr) throws IllegalArgumentException {
        try {
            return this.formatter.parse(timeStr).getTime();
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Invalid value: pattern: '" + this.tsPattern + "', value: '" + timeStr + "'", e);
        }
    }
}

