/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.Timestamp;
import java.util.Locale;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.execution.datasources.jdbc.ClickHouseDialect;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverWrapper;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.jdbc.ShardOptions;
import org.apache.spark.sql.execution.datasources.jdbc.ShardOptions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class ClickHouseDialect$
extends JdbcDialect {
    public static ClickHouseDialect$ MODULE$;
    private final Regex arrayTypePattern;
    private final Regex dateTypePattern;
    private final Regex dateTimeTypePattern;
    private final Regex decimalTypePattern;
    private final Regex decimalTypePattern2;
    private final Regex enumTypePattern;
    private final Regex fixedStringTypePattern;
    private final Regex nullableTypePattern;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;

    static {
        new ClickHouseDialect$();
    }

    public Regex arrayTypePattern() {
        return this.arrayTypePattern;
    }

    public Regex dateTypePattern() {
        return this.dateTypePattern;
    }

    public Regex dateTimeTypePattern() {
        return this.dateTimeTypePattern;
    }

    public Regex decimalTypePattern() {
        return this.decimalTypePattern;
    }

    public Regex decimalTypePattern2() {
        return this.decimalTypePattern2;
    }

    public Regex enumTypePattern() {
        return this.enumTypePattern;
    }

    public Regex fixedStringTypePattern() {
        return this.fixedStringTypePattern;
    }

    public Regex nullableTypePattern() {
        return this.nullableTypePattern;
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:clickhouse");
    }

    /*
     * Unable to fully structure code
     */
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        scale = (int)md.build().getLong("scale");
        this.logDebug((Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getCatalystType$1(int java.lang.String int int ), ()Ljava/lang/String;)((int)sqlType, (String)typeName, (int)size, (int)scale));
        var7_6 = sqlType;
        switch (var7_6) {
            case 2003: {
                var8_7 = this.unwrapNullable(typeName);
                if (var8_7 == null) ** GOTO lbl-1000
                var9_8 = (String)var8_7._2();
                var10_9 = this.arrayTypePattern().unapplySeq((CharSequence)var9_8);
                if (!var10_9.isEmpty() && var10_9.get() != null && ((LinearSeqOptimized)var10_9.get()).lengthCompare(1) == 0) {
                    nestType = (String)((LinearSeqOptimized)var10_9.get()).apply(0);
                    var5_11 = this.toCatalystType(nestType).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getCatalystType$2(scala.Tuple2 ), (Lscala/Tuple2;)Lorg/apache/spark/sql/types/DataType;)());
                } else lbl-1000:
                // 2 sources

                {
                    var5_11 = None$.MODULE$;
                }
                v0 = var5_11;
                break;
            }
            default: {
                v0 = this.toCatalystType(typeName).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getCatalystType$3(scala.Tuple2 ), (Lscala/Tuple2;)Lorg/apache/spark/sql/types/DataType;)());
                break;
            }
        }
        return v0;
    }

    public Option<Tuple2<Object, DataType>> toCatalystType(String typeName) {
        Some some;
        Option option;
        Option option2;
        String _typeName;
        Tuple2<Object, String> tuple2 = this.unwrapNullable(typeName);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean nullable = tuple2._1$mcZ$sp();
        String _typeName2 = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)nullable), (Object)_typeName2);
        Tuple2 tuple23 = tuple22;
        boolean nullable2 = tuple23._1$mcZ$sp();
        String string = _typeName = (String)tuple23._2();
        boolean bl = "String".equals(string) ? true : ("UUID".equals(string) ? true : (!(option2 = this.fixedStringTypePattern().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(0) == 0 ? true : !(option = this.enumTypePattern().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0));
        if (bl) {
            some = new Some((Object)StringType$.MODULE$);
        } else if ("Int8".equals(string)) {
            some = new Some((Object)ByteType$.MODULE$);
        } else {
            boolean bl2 = "UInt8".equals(string) ? true : "Int16".equals(string);
            if (bl2) {
                some = new Some((Object)ShortType$.MODULE$);
            } else {
                boolean bl3 = "UInt16".equals(string) ? true : "Int32".equals(string);
                if (bl3) {
                    some = new Some((Object)IntegerType$.MODULE$);
                } else {
                    boolean bl4 = "UInt32".equals(string) ? true : ("Int64".equals(string) ? true : ("UInt64".equals(string) ? true : "IPv4".equals(string)));
                    if (bl4) {
                        some = new Some((Object)LongType$.MODULE$);
                    } else {
                        boolean bl5 = "Int128".equals(string) ? true : ("Int256".equals(string) ? true : "UInt256".equals(string));
                        if (bl5) {
                            some = None$.MODULE$;
                        } else if ("Float32".equals(string)) {
                            some = new Some((Object)FloatType$.MODULE$);
                        } else if ("Float64".equals(string)) {
                            some = new Some((Object)DoubleType$.MODULE$);
                        } else {
                            Option option3 = this.dateTypePattern().unapplySeq((CharSequence)string);
                            if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(0) == 0) {
                                some = new Some((Object)DateType$.MODULE$);
                            } else {
                                Option option4 = this.dateTimeTypePattern().unapplySeq((CharSequence)string);
                                if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(0) == 0) {
                                    some = new Some((Object)TimestampType$.MODULE$);
                                } else {
                                    Option option5 = this.decimalTypePattern().unapplySeq((CharSequence)string);
                                    if (!option5.isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(2) == 0) {
                                        String precision = (String)((LinearSeqOptimized)option5.get()).apply(0);
                                        String scale = (String)((LinearSeqOptimized)option5.get()).apply(1);
                                        some = new Some((Object)new DecimalType(new StringOps(Predef$.MODULE$.augmentString(precision)).toInt(), new StringOps(Predef$.MODULE$.augmentString(scale)).toInt()));
                                    } else {
                                        Option option6 = this.decimalTypePattern2().unapplySeq((CharSequence)string);
                                        if (!option6.isEmpty() && option6.get() != null && ((LinearSeqOptimized)option6.get()).lengthCompare(2) == 0) {
                                            Some some2;
                                            String w = (String)((LinearSeqOptimized)option6.get()).apply(0);
                                            String scale = (String)((LinearSeqOptimized)option6.get()).apply(1);
                                            String string2 = w;
                                            if ("32".equals(string2)) {
                                                some2 = new Some((Object)new DecimalType(9, new StringOps(Predef$.MODULE$.augmentString(scale)).toInt()));
                                            } else if ("64".equals(string2)) {
                                                some2 = new Some((Object)new DecimalType(18, new StringOps(Predef$.MODULE$.augmentString(scale)).toInt()));
                                            } else if ("128".equals(string2)) {
                                                some2 = new Some((Object)new DecimalType(38, new StringOps(Predef$.MODULE$.augmentString(scale)).toInt()));
                                            } else if ("256".equals(string2)) {
                                                some2 = new Some((Object)new DecimalType(76, new StringOps(Predef$.MODULE$.augmentString(scale)).toInt()));
                                            } else {
                                                throw new MatchError((Object)string2);
                                            }
                                            some = some2;
                                        } else {
                                            some = None$.MODULE$;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        Some dataType = some;
        return dataType.map((Function1 & Serializable & scala.Serializable)x$3 -> new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)nullable2), x$3));
    }

    public Tuple2<Object, String> unwrapNullable(String maybeNullableTypeName) {
        Tuple2 tuple2;
        String string = maybeNullableTypeName;
        Option option = this.nullableTypePattern().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String typeName = (String)((LinearSeqOptimized)option.get()).apply(0);
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)typeName);
        } else {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)maybeNullableTypeName);
        }
        return tuple2;
    }

    public Option<JdbcType> getJDBCType(DataType dt) {
        Object object;
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("String", 12));
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("String", -2));
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("UInt8", 16));
        } else if (ByteType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("Int8", -6));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("Int16", 5));
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("Int32", 4));
        } else if (LongType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("Int64", -5));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("Float32", 6));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("Float64", 8));
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            object = new Some((Object)new JdbcType(new StringBuilder(10).append("Decimal(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")").toString(), 3));
        } else {
            ArrayType arrayType;
            DataType et;
            object = DateType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("Date", 91)) : (TimestampType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("DateTime", 93)) : (dataType instanceof ArrayType && (et = (arrayType = (ArrayType)dataType).elementType()) instanceof AtomicType ? this.getJDBCType(et).orElse((Function0 & Serializable & scala.Serializable)() -> JdbcUtils$.MODULE$.getCommonJDBCType(et)).map((Function1 & Serializable & scala.Serializable)jdbcType -> new JdbcType(new StringBuilder(7).append("Array(").append(jdbcType.databaseTypeDefinition()).append(")").toString(), 2003)) : None$.MODULE$));
        }
        return object;
    }

    public Function1<Object, Connection> createConnectionFactory(JDBCOptions options) {
        ShardOptions shards = ShardOptions$.MODULE$.create(options);
        String driverClass = options.driverClass();
        return (Function1 & Serializable & scala.Serializable)partitionId -> ClickHouseDialect$.$anonfun$createConnectionFactory$1(shards, driverClass, options, BoxesRunTime.unboxToInt((Object)partitionId));
    }

    public String quoteIdentifier(String colName) {
        return new StringBuilder(2).append("`").append(colName).append("`").toString();
    }

    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public Object compileValue(Object value2) {
        Object object;
        Object object2 = value2;
        if (object2 instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object2;
            TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.getFractionFormatter(DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone()));
            object = new StringBuilder(2).append("'").append(timestampFormatter.format(timestamp)).append("'").toString();
        } else if (object2 instanceof Date) {
            Date date = (Date)object2;
            object = new StringBuilder(10).append("toDate('").append(date).append("')").toString();
        } else if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            object = Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps((Object)objectArray).map((Function1 & Serializable & scala.Serializable)value -> MODULE$.compileValue(value), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).mkString("[", ",", "]");
        } else {
            object = super.compileValue(value2);
        }
        return object;
    }

    public String getSchemaQuery(String table) {
        return new StringBuilder(22).append("SELECT * FROM ").append(table).append(" limit 0").toString();
    }

    public Option<String> compileExpression(Expression expr) {
        Some some;
        ClickHouseDialect.ClickhouseJDBCSQLBuilder jdbcSQLBuilder = new ClickHouseDialect.ClickhouseJDBCSQLBuilder();
        try {
            some = new Some((Object)jdbcSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Error occurs while compiling V2 expression", e);
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ String $anonfun$getCatalystType$1(int sqlType$1, String typeName$1, int size$1, int scale$1) {
        return new StringBuilder(43).append("sqlType: ").append(sqlType$1).append(", typeName: ").append(typeName$1).append(", precision: ").append(size$1).append(", scale: ").append(scale$1).toString();
    }

    public static final /* synthetic */ DataType $anonfun$getCatalystType$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean nullable = tuple2._1$mcZ$sp();
        DataType dataType = (DataType)tuple2._2();
        ArrayType arrayType = new ArrayType(dataType, nullable);
        return arrayType;
    }

    public static final /* synthetic */ DataType $anonfun$getCatalystType$3(Tuple2 x$1) {
        return (DataType)x$1._2();
    }

    public static final /* synthetic */ Connection $anonfun$createConnectionFactory$1(ShardOptions shards$1, String driverClass$1, JDBCOptions options$1, int partitionId) {
        Predef$.MODULE$.require(partitionId < shards$1.shards().length);
        String url = partitionId == -1 ? shards$1.shards()[0] : shards$1.shards()[partitionId];
        MODULE$.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Create connection for shard: ").append(url).toString());
        DriverRegistry$.MODULE$.register(driverClass$1);
        Driver driver = (Driver)((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(DriverManager.getDrivers()).asScala()).collectFirst((PartialFunction)new scala.Serializable(driverClass$1){
            public static final long serialVersionUID = 0L;
            private final String driverClass$1;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends Driver, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var3_9;
                A1 A1 = x1;
                if (A1 instanceof DriverWrapper) {
                    DriverWrapper driverWrapper = (DriverWrapper)A1;
                    String string = driverWrapper.wrapped().getClass().getCanonicalName();
                    String string2 = this.driverClass$1;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        DriverWrapper driverWrapper2 = driverWrapper;
                        return var3_9;
                    }
                }
                String string = A1.getClass().getCanonicalName();
                String string3 = this.driverClass$1;
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    A1 A12 = A1;
                    return var3_9;
                }
                Object object = function1.apply(x1);
                return var3_9;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Driver x1) {
                Driver driver = x1;
                if (driver instanceof DriverWrapper) {
                    DriverWrapper driverWrapper = (DriverWrapper)driver;
                    String string = driverWrapper.wrapped().getClass().getCanonicalName();
                    String string2 = this.driverClass$1;
                    if (string == null) {
                        if (string2 == null) return true;
                    } else if (string.equals(string2)) {
                        return true;
                    }
                }
                String string = driver.getClass().getCanonicalName();
                String string3 = this.driverClass$1;
                if (string != null) {
                    if (!string.equals(string3)) return false;
                    return true;
                }
                if (string3 == null) return true;
                return false;
            }
            {
                this.driverClass$1 = driverClass$1;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(42).append("Did not find registered driver with class ").append(driverClass$1).toString());
        });
        return driver.connect(url, options$1.asConnectionProperties());
    }

    private ClickHouseDialect$() {
        MODULE$ = this;
        this.arrayTypePattern = new StringOps(Predef$.MODULE$.augmentString("^Array\\((.*)\\)$")).r();
        this.dateTypePattern = new StringOps(Predef$.MODULE$.augmentString("^[dD][aA][tT][eE]$")).r();
        this.dateTimeTypePattern = new StringOps(Predef$.MODULE$.augmentString("^[dD][aA][tT][eE][tT][iI][mM][eE](64)?(\\((.*)\\))?$")).r();
        this.decimalTypePattern = new StringOps(Predef$.MODULE$.augmentString("^[dD][eE][cC][iI][mM][aA][lL]\\((\\d+),\\s*(\\d+)\\)$")).r();
        this.decimalTypePattern2 = new StringOps(Predef$.MODULE$.augmentString("^[dD][eE][cC][iI][mM][aA][lL](32|64|128|256)\\((\\d+)\\)$")).r();
        this.enumTypePattern = new StringOps(Predef$.MODULE$.augmentString("^Enum(8|16)$")).r();
        this.fixedStringTypePattern = new StringOps(Predef$.MODULE$.augmentString("^FixedString\\((\\d+)\\)$")).r();
        this.nullableTypePattern = new StringOps(Predef$.MODULE$.augmentString("^Nullable\\((.*)\\)")).r();
        this.supportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG"}));
        this.supportedFunctions = (Set)this.supportedAggregateFunctions().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ABS", "COALESCE", "GREATEST", "LEAST", "RAND", "LOG", "LOG10", "LOG2", "LN", "EXP", "POWER", "SQRT", "FLOOR", "CEIL", "ROUND", "SIN", "SINH", "COS", "COSH", "TAN", "TANH", "COT", "ASIN", "ACOS", "ATAN", "ATAN2", "DEGREES", "RADIANS", "SIGN", "PI", "CBRT", "SUBSTRING", "UPPER", "LOWER", "TRANSLATE", "TRIM", "DATE_ADD", "DATE_DIFF", "TRUNC", "CHAR_LENGTH", "CONCAT"})));
    }
}

