/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.datasource.storage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.utils.JobMetrics;
import org.apache.kylin.engine.spark.utils.Metrics$;
import org.apache.kylin.engine.spark.utils.Repartitioner;
import org.apache.kylin.engine.spark.utils.StorageUtils$;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.LayoutPartition;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.LayoutEntityConverter$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.datasource.storage.StorageStore;
import org.apache.spark.sql.datasource.storage.WriteTaskStats;
import org.apache.spark.sql.execution.datasource.FilePruner;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u0005\u000b\u0001]AQ\u0001\b\u0001\u0005\u0002uAQa\b\u0001\u0005B\u0001BQ\u0001\u0017\u0001\u0005\neCQ!\u001f\u0001\u0005\u0002iDq!a\u0003\u0001\t\u0003\ni\u0001C\u0005\u0002B\u0001\t\n\u0011\"\u0001\u0002D!9\u0011\u0011\f\u0001\u0005B\u0005m\u0003bBA-\u0001\u0011\u0005\u0013Q\u000e\u0002\u000f'R|'/Y4f'R|'/\u001a,2\u0015\tYA\"A\u0004ti>\u0014\u0018mZ3\u000b\u00055q\u0011A\u00033bi\u0006\u001cx.\u001e:dK*\u0011q\u0002E\u0001\u0004gFd'BA\t\u0013\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019B#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002+\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033ii\u0011AC\u0005\u00037)\u0011Ab\u0015;pe\u0006<Wm\u0015;pe\u0016\fa\u0001P5oSRtD#\u0001\u0010\u0011\u0005e\u0001\u0011\u0001B:bm\u0016$R!\t\u00133y\u0011\u0003\"!\u0007\u0012\n\u0005\rR!AD,sSR,G+Y:l'R\fGo\u001d\u0005\u0006K\t\u0001\rAJ\u0001\u0007Y\u0006Lx.\u001e;\u0011\u0005\u001d\u0002T\"\u0001\u0015\u000b\u0005%R\u0013!B7pI\u0016d'BA\u0016-\u0003\u0011\u0019WOY3\u000b\u00055r\u0013\u0001C7fi\u0006$\u0017\r^1\u000b\u0005=\u0012\u0012!B6zY&t\u0017BA\u0019)\u00051a\u0015-_8vi\u0016sG/\u001b;z\u0011\u0015\u0019$\u00011\u00015\u0003)yW\u000f\u001e9viB\u000bG\u000f\u001b\t\u0003kij\u0011A\u000e\u0006\u0003oa\n!AZ:\u000b\u0005e\u0012\u0012A\u00025bI>|\u0007/\u0003\u0002<m\t!\u0001+\u0019;i\u0011\u0015i$\u00011\u0001?\u0003%Y\u0017\r]\"p]\u001aLw\r\u0005\u0002@\u00056\t\u0001I\u0003\u0002B]\u000511m\\7n_:L!a\u0011!\u0003\u0013-\u000b\u0007oQ8oM&<\u0007\"B#\u0003\u0001\u00041\u0015!\u00033bi\u00064%/Y7f!\t9UK\u0004\u0002I':\u0011\u0011J\u0015\b\u0003\u0015Fs!a\u0013)\u000f\u00051{U\"A'\u000b\u000593\u0012A\u0002\u001fs_>$h(C\u0001\u0016\u0013\t\u0019B#\u0003\u0002\u0012%%\u0011q\u0002E\u0005\u0003):\tq\u0001]1dW\u0006<W-\u0003\u0002W/\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003):\t\u0011C]3qCJ$\u0018\u000e^5p]^\u0013\u0018\u000e^3s)\u0015QVO^<y!\u0019Yf\fY5me6\tALC\u0001^\u0003\u0015\u00198-\u00197b\u0013\tyFL\u0001\u0004UkBdW\r\u000e\t\u0003C\u001el\u0011A\u0019\u0006\u0003G\u0012\fQ!\u001e;jYNT!!E3\u000b\u0005\u0019t\u0013AB3oO&tW-\u0003\u0002iE\nQ!j\u001c2NKR\u0014\u0018nY:\u0011\u0005mS\u0017BA6]\u0005\u0011auN\\4\u0011\u00055\u0004X\"\u00018\u000b\u0005=D\u0014\u0001B2p]\u001aL!!\u001d8\u0003\u001b\r{gNZ5hkJ\fG/[8o!\tY6/\u0003\u0002u9\n\u0019\u0011J\u001c;\t\u000b\u0015\u001a\u0001\u0019\u0001\u0014\t\u000bM\u001a\u0001\u0019\u0001\u001b\t\u000bu\u001a\u0001\u0019\u0001 \t\u000b\u0015\u001b\u0001\u0019\u0001$\u0002=\rDWmY6B]\u0012<&/\u001b;fe\u001a\u000b7\u000f\u001e\"ji6\f\u0007\u000fT1z_V$H\u0003C>\u007f\u0003\u0003\t)!a\u0002\u0011\u0005mc\u0018BA?]\u0005\u0011)f.\u001b;\t\u000b}$\u0001\u0019\u0001$\u0002\u000f\u0011\fG/Y:fi\"1\u00111\u0001\u0003A\u0002\u0019\nA\u0002\\1z_V$XI\u001c;jifDQ!\u0010\u0003A\u0002yBa!!\u0003\u0005\u0001\u0004!\u0014A\u00037bs>,H\u000fU1uQ\u0006!!/Z1e)%1\u0015qBA\r\u00037\t9\u0003C\u0004\u0002\u0012\u0015\u0001\r!a\u0005\u0002\u0011\u0011\fG/\u00194m_^\u00042aJA\u000b\u0013\r\t9\u0002\u000b\u0002\n\u001d\u0012\u000bG/\u00194m_^DQ!J\u0003A\u0002\u0019Bq!!\b\u0006\u0001\u0004\ty\"\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0003\u0002\"\u0005\rR\"\u0001\b\n\u0007\u0005\u0015bB\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0005\u0002*\u0015\u0001\n\u00111\u0001\u0002,\u0005aQ\r\u001f;sC>\u0003H/[8ogBA\u0011QFA\u001b\u0003w\tYD\u0004\u0003\u00020\u0005E\u0002C\u0001']\u0013\r\t\u0019\u0004X\u0001\u0007!J,G-\u001a4\n\t\u0005]\u0012\u0011\b\u0002\u0004\u001b\u0006\u0004(bAA\u001a9B!\u0011QFA\u001f\u0013\u0011\ty$!\u000f\u0003\rM#(/\u001b8h\u00039\u0011X-\u00193%I\u00164\u0017-\u001e7uIQ*\"!!\u0012+\t\u0005-\u0012qI\u0016\u0003\u0003\u0013\u0002B!a\u0013\u0002V5\u0011\u0011Q\n\u0006\u0005\u0003\u001f\n\t&A\u0005v]\u000eDWmY6fI*\u0019\u00111\u000b/\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002X\u00055#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0011\"/Z1e'B,7-[1m'\u0016<W.\u001a8u)%1\u0015QLA4\u0003S\nY\u0007C\u0004\u0002`\u001d\u0001\r!!\u0019\u0002\u000fM,w-\\3oiB\u0019q%a\u0019\n\u0007\u0005\u0015\u0004F\u0001\u0007O\t\u0006$\u0018mU3h[\u0016tG\u000fC\u0003&\u000f\u0001\u0007a\u0005C\u0004\u0002\u001e\u001d\u0001\r!a\b\t\u0013\u0005%r\u0001%AA\u0002\u0005-B#\u0003$\u0002p\u0005E\u00141OAC\u0011\u001d\ty\u0006\u0003a\u0001\u0003CBQ!\n\u0005A\u0002\u0019Bq!!\u001e\t\u0001\u0004\t9(A\u0006qCJ$\u0018\u000e^5p]&#\u0007\u0003BA=\u0003\u0007k!!a\u001f\u000b\t\u0005u\u0014qP\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0002\u0006!!.\u0019<b\u0013\rY\u00171\u0010\u0005\b\u0003;A\u0001\u0019AA\u0010\u0001")
public class StorageStoreV1
extends StorageStore {
    @Override
    public WriteTaskStats save(LayoutEntity layout, Path outputPath, KapConfig kapConfig, Dataset<Row> dataFrame) {
        long l;
        JobMetrics jobMetrics;
        int bucketNum;
        Configuration hadoopConf;
        block5: {
            Tuple4<JobMetrics, Object, Configuration, Object> tuple4;
            block4: {
                tuple4 = this.repartitionWriter(layout, outputPath, kapConfig, dataFrame);
                if (tuple4 == null) break block4;
                JobMetrics metrics = (JobMetrics)tuple4._1();
                long rowCount = BoxesRunTime.unboxToLong((Object)tuple4._2());
                hadoopConf = (Configuration)tuple4._3();
                bucketNum = BoxesRunTime.unboxToInt((Object)tuple4._4());
                if (metrics == null) break block4;
                jobMetrics = metrics;
                l = rowCount;
                if (hadoopConf != null) break block5;
            }
            throw new MatchError(tuple4);
        }
        Configuration configuration = hadoopConf;
        int n = bucketNum;
        Tuple4 tuple4 = new Tuple4((Object)jobMetrics, (Object)BoxesRunTime.boxToLong((long)l), (Object)configuration, (Object)BoxesRunTime.boxToInteger((int)n));
        Tuple4 tuple42 = tuple4;
        JobMetrics metrics = (JobMetrics)tuple42._1();
        long rowCount = BoxesRunTime.unboxToLong((Object)tuple42._2());
        Configuration hadoopConf2 = (Configuration)tuple42._3();
        int bucketNum2 = BoxesRunTime.unboxToInt((Object)tuple42._4());
        Tuple2<Object, Object> tuple2 = this.collectFileCountAndSizeAfterSave(outputPath, hadoopConf2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long fileCount = tuple2._1$mcJ$sp();
        long byteSize = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(fileCount, byteSize);
        Tuple2.mcJJ.sp sp3 = sp2;
        long fileCount2 = sp3._1$mcJ$sp();
        long byteSize2 = sp3._2$mcJ$sp();
        this.checkAndWriterFastBitmapLayout(dataFrame, layout, kapConfig, outputPath);
        return new WriteTaskStats(0, fileCount2, byteSize2, rowCount, metrics.getMetrics(Metrics$.MODULE$.SOURCE_ROWS_CNT()), bucketNum2, new ArrayList<String>());
    }

    private Tuple4<JobMetrics, Object, Configuration, Object> repartitionWriter(LayoutEntity layout, Path outputPath, KapConfig kapConfig, Dataset<Row> dataFrame) {
        SparkSession ss = dataFrame.sparkSession();
        Configuration hadoopConf = ss.sparkContext().hadoopConfiguration();
        FileSystem fs = outputPath.getFileSystem(hadoopConf);
        String tempPath = new StringBuilder(0).append(outputPath.toString()).append(this.TEMP_FLAG()).append(System.currentTimeMillis()).toString();
        JobMetrics metrics = StorageUtils$.MODULE$.writeWithMetrics(dataFrame, tempPath);
        long rowCount = metrics.getMetrics(Metrics$.MODULE$.CUBOID_ROWS_CNT());
        this.storageListener().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.onPersistBeforeRepartition((Dataset<Row>)dataFrame, layout);
            return BoxedUnit.UNIT;
        });
        int bucketNum = StorageUtils$.MODULE$.calculateBucketNum(tempPath, layout, rowCount, kapConfig);
        ContentSummary summary = HadoopUtil.getContentSummary((FileSystem)fs, (Path)new Path(tempPath));
        long repartitionThresholdSize = StorageUtils$.MODULE$.findCountDistinctMeasure(layout) ? kapConfig.getParquetStorageCountDistinctShardSizeRowCount() : kapConfig.getParquetStorageShardSizeRowCount();
        Repartitioner repartitioner = new Repartitioner(kapConfig.getParquetStorageShardSizeMB(), kapConfig.getParquetStorageRepartitionThresholdSize(), rowCount, repartitionThresholdSize, summary, layout.getShardByColumns(), (List<Integer>)layout.getOrderedDimensions().keySet().asList(), kapConfig.optimizeShardEnabled());
        repartitioner.doRepartition(outputPath.toString(), tempPath, bucketNum, ss);
        this.storageListener().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.onPersistAfterRepartition((Dataset<Row>)ss.read().parquet(outputPath.toString()), layout);
            return BoxedUnit.UNIT;
        });
        return new Tuple4((Object)metrics, (Object)BoxesRunTime.boxToLong((long)rowCount), (Object)hadoopConf, (Object)BoxesRunTime.boxToInteger((int)bucketNum));
    }

    public void checkAndWriterFastBitmapLayout(Dataset<Row> dataset, LayoutEntity layoutEntity, KapConfig kapConfig, Path layoutPath) {
        if (!layoutEntity.getIndex().getIndexPlan().isFastBitmapEnabled()) {
            return;
        }
        List bitmaps = layoutEntity.listBitmapMeasure();
        if (bitmaps.isEmpty()) {
            return;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Begin write fast bitmap cuboid. layout id is ").append(layoutEntity.getId()).toString());
        Path outputPath = new Path(new StringBuilder(12).append(layoutPath.toString()).append("_fast_bitmap").toString());
        Dataset afterReplaced = StorageStoreV1.replaceCountDistinctEvalColumn$1(bitmaps, dataset);
        this.repartitionWriter(layoutEntity, outputPath, kapConfig, (Dataset<Row>)afterReplaced);
    }

    @Override
    public Dataset<Row> read(NDataflow dataflow, LayoutEntity layout, SparkSession sparkSession, Map<String, String> extraOptions) {
        StructType structType = "true".equals(extraOptions.apply((Object)"isFastBitmapEnabled")) ? LayoutEntityConverter$.MODULE$.LayoutEntityConverter(layout).toExactlySchema() : LayoutEntityConverter$.MODULE$.LayoutEntityConverter(layout).toSchema();
        FilePruner indexCatalog = new FilePruner(sparkSession, extraOptions, structType);
        return sparkSession.baseRelationToDataFrame((BaseRelation)new HadoopFsRelation((FileIndex)indexCatalog, indexCatalog.partitionSchema(), indexCatalog.dataSchema().asNullable(), (Option)None$.MODULE$, (FileFormat)new ParquetFileFormat(), extraOptions, sparkSession));
    }

    @Override
    public Map<String, String> read$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    @Override
    public Dataset<Row> readSpecialSegment(NDataSegment segment, LayoutEntity layout, SparkSession sparkSession, Map<String, String> extraOptions) {
        long layoutId = layout.getId();
        String path = NSparkCubingUtil.getStoragePath(segment, Predef$.MODULE$.long2Long(layoutId));
        return sparkSession.read().parquet(path);
    }

    @Override
    public Dataset<Row> readSpecialSegment(NDataSegment segment, LayoutEntity layout, Long partitionId, SparkSession sparkSession) {
        long layoutId = layout.getId();
        LayoutPartition dataPartition = segment.getLayout(layoutId).getDataPartition(partitionId);
        Predef$.MODULE$.require(Objects.nonNull(dataPartition));
        String path = NSparkCubingUtil.getStoragePath(segment, Predef$.MODULE$.long2Long(layoutId), Predef$.MODULE$.long2Long(dataPartition.getBucketId()));
        return sparkSession.read().parquet(path);
    }

    private static final Dataset replaceCountDistinctEvalColumn$1(List list, Dataset dataFrame) {
        Column[] columns = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataFrame.schema().names())).map((Function1 & Serializable & scala.Serializable)name -> list.contains(name) ? functions$.MODULE$.callUDF("eval_bitmap", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(name)})).as(name) : functions$.MODULE$.col(name), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        return dataFrame.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])columns));
    }
}

