/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.dict;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.IOException;
import org.apache.spark.dict.NGlobalDictMetaInfo;
import org.apache.spark.dict.NGlobalDictStore;
import org.apache.spark.dict.NGlobalDictStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NBucketDictionary {
    protected static final Logger logger = LoggerFactory.getLogger(NBucketDictionary.class);
    private String workingDir;
    private int bucketId;
    private Object2LongMap<String> absoluteDictMap;
    private Object2LongMap<String> relativeDictMap;

    NBucketDictionary(String baseDir, String workingDir, int bucketId, NGlobalDictMetaInfo metainfo) throws IOException {
        this.workingDir = workingDir;
        this.bucketId = bucketId;
        NGlobalDictStore globalDictStore = NGlobalDictStoreFactory.getResourceStore(baseDir);
        Long[] versions = globalDictStore.listAllVersions();
        logger.debug("versions.length is {}", (Object)versions.length);
        this.absoluteDictMap = versions.length == 0 ? new Object2LongOpenHashMap() : globalDictStore.getBucketDict(versions[versions.length - 1], metainfo, bucketId);
        this.relativeDictMap = new Object2LongOpenHashMap();
    }

    NBucketDictionary(String workingDir) {
        this.workingDir = workingDir;
        this.absoluteDictMap = new Object2LongOpenHashMap();
        this.relativeDictMap = new Object2LongOpenHashMap();
    }

    public void addRelativeValue(String value) {
        if (null == value) {
            return;
        }
        if (this.absoluteDictMap.containsKey((Object)value)) {
            return;
        }
        this.relativeDictMap.put((Object)value, (long)this.relativeDictMap.size() + 1L);
    }

    public void addAbsoluteValue(String value, long encodeValue) {
        this.absoluteDictMap.put((Object)value, encodeValue);
    }

    public long encode(Object value) {
        return this.absoluteDictMap.getLong((Object)value.toString());
    }

    public void saveBucketDict(int bucketId) throws IOException {
        this.writeBucketCurrDict(bucketId);
        this.writeBucketPrevDict(bucketId);
    }

    private void writeBucketPrevDict(int bucketId) throws IOException {
        if (this.absoluteDictMap.isEmpty()) {
            return;
        }
        NGlobalDictStore globalDictStore = NGlobalDictStoreFactory.getResourceStore(this.workingDir);
        globalDictStore.writeBucketPrevDict(this.workingDir, bucketId, this.absoluteDictMap);
    }

    private void writeBucketCurrDict(int bucketId) throws IOException {
        if (this.relativeDictMap.isEmpty()) {
            return;
        }
        NGlobalDictStore globalDictStore = NGlobalDictStoreFactory.getResourceStore(this.workingDir);
        globalDictStore.writeBucketCurrDict(this.workingDir, bucketId, this.relativeDictMap);
    }

    public Object2LongMap<String> getAbsoluteDictMap() {
        return this.absoluteDictMap;
    }

    public Object2LongMap<String> getRelativeDictMap() {
        return this.relativeDictMap;
    }

    public int getBucketId() {
        return this.bucketId;
    }

    public void setBucketId(int bucketId) {
        this.bucketId = bucketId;
    }
}

