/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.utils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.engine.spark.utils.JobMetrics;
import org.apache.kylin.engine.spark.utils.JobMetricsUtils$;
import org.apache.kylin.engine.spark.utils.QueryExecutionCache$;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class StorageUtils$
implements Logging {
    public static StorageUtils$ MODULE$;
    private final long MB;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new StorageUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public long MB() {
        return this.MB;
    }

    public void overwriteWithMessage(FileSystem fs, Path src, Path dst) {
        Object object = fs.exists(dst) ? BoxesRunTime.boxToBoolean((boolean)fs.delete(dst, true)) : BoxedUnit.UNIT;
        if (!fs.rename(src, dst)) {
            throw new RuntimeException(new StringBuilder(41).append("Rename src path (").append(src).append(") to dst path (").append(dst).append(") failed.").toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Rename src path (").append(src).append(") to dst path (").append(dst).append(") successfully.").toString());
    }

    public void cleanupPotentialTempFiles(FileSystem fs, Path targetPath, boolean includeSelf) {
        block1: {
            if (fs.exists(targetPath) && includeSelf) {
                fs.delete(targetPath, true);
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Delete dir ").append(targetPath).toString());
            }
            if (!fs.exists(targetPath.getParent())) break block1;
            String namePrefix = new StringBuilder(5).append(targetPath.getName()).append("_temp").toString();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(targetPath.getParent(), new PathFilter(namePrefix){
                private final String namePrefix$1;

                public boolean accept(Path destPath) {
                    return destPath.getName().startsWith(this.namePrefix$1);
                }
                {
                    this.namePrefix$1 = namePrefix$1;
                }
            }))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))))).foreach((Function1 & Serializable & scala.Serializable)tempPath -> {
                StorageUtils$.$anonfun$cleanupPotentialTempFiles$3(fs, tempPath);
                return BoxedUnit.UNIT;
            });
        }
    }

    public boolean findCountDistinctMeasure(LayoutEntity layout) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter((Set)layout.getOrderedMeasures().values()).asScala()).exists((Function1 & Serializable & scala.Serializable)measure -> BoxesRunTime.boxToBoolean((boolean)StorageUtils$.$anonfun$findCountDistinctMeasure$1(measure)));
    }

    public JobMetrics writeWithMetrics(Dataset<Row> data, String path) {
        return this.withMetrics(data.sparkSession(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> data.write().mode(SaveMode.Overwrite).parquet(path));
    }

    public JobMetrics withMetrics(SparkSession session, Function0<BoxedUnit> body) {
        String queryExecutionId = RandomUtil.randomUUIDStr();
        session.sparkContext().setLocalProperty(QueryExecutionCache$.MODULE$.N_EXECUTION_ID_KEY(), queryExecutionId);
        body.apply$mcV$sp();
        JobMetrics metrics = JobMetricsUtils$.MODULE$.collectMetrics(queryExecutionId);
        session.sparkContext().setLocalProperty(QueryExecutionCache$.MODULE$.N_EXECUTION_ID_KEY(), null);
        QueryExecutionCache$.MODULE$.removeQueryExecution(queryExecutionId);
        return metrics;
    }

    public int calculateBucketNum(String tempPath, LayoutEntity layout, long rowCount, KapConfig kapConfig) {
        int n;
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        if (fs.exists(new Path(tempPath))) {
            ContentSummary summary = HadoopUtil.getContentSummary((FileSystem)fs, (Path)new Path(tempPath));
            long repartitionThresholdSize = this.findCountDistinctMeasure(layout) ? kapConfig.getParquetStorageCountDistinctShardSizeRowCount() : kapConfig.getParquetStorageShardSizeRowCount();
            int partitionNumByStorage = this.getRepartitionNumByStorage(summary.getLength(), kapConfig.getParquetStorageShardSizeMB(), rowCount, repartitionThresholdSize);
            Map extConfig = layout.getIndex().getModel().getProjectInstance().getConfig().getExtendedOverrides();
            String configJson = (String)extConfig.get("kylin.engine.shard-num-json");
            List shardByColumns = layout.getShardByColumns();
            if (configJson != null) {
                try {
                    Map colToShardsNum = JsonUtil.readValueAsMap((String)configJson);
                    String shardColIdentity = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(shardByColumns).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> ((TblColRef)layout.getIndex().getModel().getEffectiveDimensions().get(x$2)).toString(), Buffer$.MODULE$.canBuildFrom())).mkString(",");
                    int num = new StringOps(Predef$.MODULE$.augmentString(colToShardsNum.getOrDefault(shardColIdentity, String.valueOf(partitionNumByStorage)))).toInt();
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Get  num in config, col identity is:").append(shardColIdentity).append(", bucket num is ").append(num).append(".").toString());
                    n = num;
                }
                catch (Throwable th) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred when getting bucket num in config", th);
                    n = partitionNumByStorage;
                }
            } else {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Get partition num by file storage, partition num is ").append(partitionNumByStorage).append(".").toString());
                n = partitionNumByStorage;
            }
        } else {
            throw new RuntimeException(new StringBuilder(57).append("Temp path does not exist before repartition. Temp path: ").append(tempPath).append(".").toString());
        }
        int repartitionNum = n;
        return repartitionNum;
    }

    private int getRepartitionNumByStorage(long fileLength, int bucketSize, long totalRowCount, long rowCountSize) {
        int fileLengthRepartitionNum = (int)Math.ceil((double)fileLength * 1.0 / (double)this.MB() / (double)bucketSize);
        int rowCountRepartitionNum = (int)Math.ceil(1.0 * (double)totalRowCount / (double)rowCountSize);
        int partitionSize = (int)Math.ceil(1.0 * (double)(fileLengthRepartitionNum + rowCountRepartitionNum) / (double)2);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(81).append("File length repartition num : ").append(fileLengthRepartitionNum).append(", row count Rpartition num: ").append(rowCountRepartitionNum).append(",").append(" repartition num is : ").append(partitionSize).toString());
        return partitionSize;
    }

    /*
     * WARNING - void declaration
     */
    public YarnConfiguration getCurrentYarnConfiguration() {
        void var1_1;
        YarnConfiguration conf = new YarnConfiguration();
        this.setSystemPropertiesToYarnYarnConfiguration(conf);
        return var1_1;
    }

    private void setSystemPropertiesToYarnYarnConfiguration(YarnConfiguration conf) {
        ((IterableLike)((SetLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(System.getProperties().entrySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StorageUtils$.$anonfun$setSystemPropertiesToYarnYarnConfiguration$1(x$3)))).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)((String)entry.getKey()).substring("spark.hadoop.".length()), (Object)((String)entry.getValue())), Set$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)tp -> {
            conf.set((String)tp._1(), (String)tp._2());
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public YarnConfiguration getCurrentYarnConfigurationFromWriteCluster() {
        void var1_1;
        YarnConfiguration conf = new YarnConfiguration(HadoopUtil.getHadoopConfFromSparkEngine());
        this.setSystemPropertiesToYarnYarnConfiguration(conf);
        return var1_1;
    }

    public static final /* synthetic */ void $anonfun$cleanupPotentialTempFiles$3(FileSystem fs$1, Path tempPath) {
        block0: {
            if (!fs$1.exists(tempPath)) break block0;
            fs$1.delete(tempPath, true);
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Delete temp dir ").append(tempPath).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$findCountDistinctMeasure$1(NDataModel.Measure measure) {
        return measure.getFunction().getReturnType().equalsIgnoreCase("bitmap");
    }

    public static final /* synthetic */ boolean $anonfun$setSystemPropertiesToYarnYarnConfiguration$1(Map.Entry x$3) {
        return ((String)x$3.getKey()).startsWith("spark.hadoop.");
    }

    private StorageUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.MB = 0x100000L;
    }
}

