/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Repartitioner {
    protected static final Logger logger = LoggerFactory.getLogger(Repartitioner.class);
    private int MB = 0x100000;
    private int shardSize;
    private int fileLengthThreshold;
    private long totalRowCount;
    private long rowCountThreshold;
    private ContentSummary contentSummary;
    private List<Integer> shardByColumns = new ArrayList<Integer>();
    private List<Integer> sortByColumns;
    private boolean optimizeShardEnabled;

    public Repartitioner(int shardSize, int fileLengthThreshold, long totalRowCount, long rowCountThreshold, ContentSummary contentSummary, List<Integer> shardByColumns, List<Integer> sortByColumns, boolean optimizeShardEnabled) {
        this.shardSize = shardSize;
        this.fileLengthThreshold = fileLengthThreshold;
        this.totalRowCount = totalRowCount;
        this.rowCountThreshold = rowCountThreshold;
        this.contentSummary = contentSummary;
        if (shardByColumns != null) {
            this.shardByColumns = shardByColumns;
        }
        this.sortByColumns = sortByColumns;
        this.optimizeShardEnabled = optimizeShardEnabled;
    }

    boolean needRepartitionForFileSize() {
        return (double)this.contentSummary.getLength() * 1.0 / (double)this.MB / (double)this.contentSummary.getFileCount() < (double)this.fileLengthThreshold && this.contentSummary.getFileCount() > 1L;
    }

    boolean needRepartitionForShardByColumns() {
        return this.shardByColumns != null && !this.shardByColumns.isEmpty();
    }

    private boolean needRepartitionForRowCount() {
        return (double)this.contentSummary.getFileCount() < (double)this.totalRowCount / (double)this.rowCountThreshold * 0.75;
    }

    @VisibleForTesting
    public boolean needRepartition() {
        boolean needRepartition;
        if (this.needRepartitionForShardByColumns()) {
            return true;
        }
        boolean bl = needRepartition = this.needRepartitionForFileSize() || this.needRepartitionForRowCount();
        if (needRepartition && (long)this.getRepartitionNumByStorage() == this.contentSummary.getFileCount()) {
            needRepartition = false;
        }
        return needRepartition;
    }

    public int getShardSize() {
        return this.shardSize;
    }

    public int getFileLengthThreshold() {
        return this.fileLengthThreshold;
    }

    public ContentSummary getContentSummary() {
        return this.contentSummary;
    }

    private List<Integer> getShardByColumns() {
        return this.shardByColumns;
    }

    private int getFileLengthRepartitionNum() {
        return (int)Math.ceil((double)this.contentSummary.getLength() * 1.0 / (double)this.MB / (double)this.shardSize);
    }

    private int getRowCountRepartitionNum() {
        return (int)Math.ceil(1.0 * (double)this.totalRowCount / (double)this.rowCountThreshold);
    }

    public int getRepartitionNumByStorage() {
        int fileLengthRepartitionNum = this.getFileLengthRepartitionNum();
        int rowCountRepartitionNum = this.getRowCountRepartitionNum();
        logger.info("File length repartition num : {}, Row count Rpartition num: {}", (Object)fileLengthRepartitionNum, (Object)rowCountRepartitionNum);
        int partitionSize = (int)Math.ceil(1.0 * (double)(fileLengthRepartitionNum + rowCountRepartitionNum) / 2.0);
        logger.info("Repartition size is :{}", (Object)partitionSize);
        return partitionSize;
    }

    public void doRepartition(String outputPath, String inputPath, int repartitionNum, SparkSession ss) throws IOException {
        Path tempResourcePath = new Path(inputPath);
        FileSystem readFileSystem = HadoopUtil.getWorkingFileSystem();
        if (this.needRepartition()) {
            Dataset data;
            logger.info("Repartition {} to {}, [repartition number: {}, use shard column: {}]", new Object[]{inputPath, outputPath, repartitionNum, this.needRepartitionForShardByColumns()});
            long start = System.currentTimeMillis();
            if (this.needRepartitionForShardByColumns()) {
                if (this.optimizeShardEnabled) {
                    ss.sessionState().conf().setLocalProperty("spark.sql.adaptive.skewRepartition.enabled", "true");
                }
                data = ss.read().parquet(inputPath).repartition(repartitionNum, this.convertIntegerToColumns(this.getShardByColumns())).sortWithinPartitions(this.convertIntegerToColumns(this.sortByColumns));
            } else {
                data = ss.read().parquet(inputPath).repartition(repartitionNum).sortWithinPartitions(this.convertIntegerToColumns(this.sortByColumns));
            }
            data.write().mode(SaveMode.Overwrite).parquet(outputPath);
            if (this.needRepartitionForShardByColumns() && this.optimizeShardEnabled) {
                ss.sessionState().conf().setLocalProperty("spark.sql.adaptive.skewRepartition.enabled", null);
            }
            if (readFileSystem.delete(tempResourcePath, true)) {
                logger.info("Delete temp cuboid path successful. Temp path: {}.", (Object)inputPath);
            } else {
                logger.error("Delete temp cuboid path wrong, leave garbage. Temp path: {}.", (Object)inputPath);
            }
            long end = System.currentTimeMillis();
            logger.info("Repartition and rewrite ends. Cost: {} ms.", (Object)(end - start));
        } else {
            Path goalPath = new Path(outputPath);
            if (readFileSystem.exists(goalPath)) {
                logger.info("Path {} is exists, delete it.", (Object)goalPath);
                readFileSystem.delete(goalPath, true);
            }
            if (readFileSystem.rename(new Path(inputPath), goalPath)) {
                logger.info("Rename temp path to target path successfully. Temp path: {}, target path: {}.", (Object)inputPath, (Object)outputPath);
            } else {
                throw new RuntimeException(String.format(Locale.ROOT, "Rename temp path to target path wrong. Temp path: %s, target path: %s.", inputPath, outputPath));
            }
        }
    }

    private Column[] convertIntegerToColumns(List<Integer> indices) {
        Column[] ret = new Column[indices.size()];
        int index = 0;
        for (Integer i : indices) {
            ret[index] = new Column(String.valueOf(i));
            ++index;
        }
        return ret;
    }
}

