/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.asyncprofiler;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class AsyncArchUtil {
    private static final Map<String, ArchType> ARCH_TO_PROCESSOR = new HashMap<String, ArchType>();

    public static ArchType getProcessor() {
        return AsyncArchUtil.getProcessor(AsyncArchUtil.getSystemProperty("os.arch"));
    }

    public static ArchType getProcessor(String osArch) {
        return ARCH_TO_PROCESSOR.get(osArch);
    }

    private static String getSystemProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    private static void addProcessors(ArchType archType, String ... keys) {
        Stream.of(keys).forEach(key -> ARCH_TO_PROCESSOR.put((String)key, archType));
    }

    static {
        AsyncArchUtil.addProcessors(ArchType.LINUX_X64, "x86_64", "amd64");
        AsyncArchUtil.addProcessors(ArchType.LINUX_ARM64, "aarch64");
    }

    public static enum ArchType {
        LINUX_X64,
        LINUX_ARM64;

    }
}

