/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc.metadata;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.SourceDialect;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.source.hive.DBConnConf;
import org.apache.kylin.source.jdbc.SqlUtil;
import org.apache.kylin.source.jdbc.metadata.DefaultJdbcMetadata;

public class SQLServerJdbcMetadata
extends DefaultJdbcMetadata {
    public SQLServerJdbcMetadata(DBConnConf dbConnConf) {
        super(dbConnConf);
    }

    @Override
    public List<String> listDatabases() throws SQLException {
        HashSet<String> ret = new HashSet<String>();
        try (Connection con = SqlUtil.getConnection(this.dbconf);){
            String database = con.getCatalog();
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)database), (Object)"SQL Server needs a specific database in connection string.");
            try (ResultSet rs = con.getMetaData().getTables(database, null, null, null);){
                while (rs.next()) {
                    String schema = rs.getString("TABLE_SCHEM");
                    String catalog = rs.getString("TABLE_CAT");
                    if (!database.equals(catalog) && !schema.equals("dbo")) continue;
                    ret.add(schema);
                }
            }
        }
        return new ArrayList<String>(ret);
    }

    @Override
    public SourceDialect getDialect() {
        return SourceDialect.MSSQL;
    }
}

