/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.source.hive.DBConnConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUtil {
    private static final Logger logger = LoggerFactory.getLogger(SqlUtil.class);
    private static final Random r = new Random();
    public static final int tryTimes = 5;
    public static final String DRIVER_MISS = "DRIVER_MISS";

    private SqlUtil() {
        throw new IllegalStateException("Class CheckUtil is an utility class !");
    }

    public static void closeResources(Connection con, Statement statement) {
        try {
            if (statement != null && !statement.isClosed()) {
                statement.close();
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        try {
            if (con != null && !con.isClosed()) {
                con.close();
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    public static void execUpdateSQL(Connection db, String sql) throws SQLException {
        try (Statement statement = db.createStatement();){
            statement.executeUpdate(sql);
        }
    }

    public static Connection getConnection(DBConnConf dbconf) {
        if (dbconf.getUrl() == null) {
            return null;
        }
        Connection con = null;
        try {
            Class.forName(dbconf.getDriver());
        }
        catch (Exception e) {
            logger.error("Miss Driver", (Throwable)e);
            throw new IllegalStateException(DRIVER_MISS);
        }
        boolean got = false;
        int times = 0;
        while (!got && times < 5) {
            ++times;
            try {
                con = DriverManager.getConnection(dbconf.getUrl(), dbconf.getUser(), dbconf.getPass());
                got = true;
            }
            catch (Exception e) {
                logger.warn("while use:" + dbconf, (Throwable)e);
                try {
                    int rt = r.nextInt(10);
                    Thread.sleep((long)rt * 1000L);
                }
                catch (InterruptedException e1) {
                    Thread.interrupted();
                }
            }
        }
        if (null == con) {
            throw new IllegalStateException("Can not connect to the data source.");
        }
        return con;
    }

    public static String jdbcTypeToKylinDataType(int sqlType) {
        String result = "any";
        switch (sqlType) {
            case 1: {
                result = "char";
                break;
            }
            case -9: 
            case -1: 
            case 12: {
                result = "varchar";
                break;
            }
            case 2: 
            case 3: {
                result = "decimal";
                break;
            }
            case -7: 
            case 16: {
                result = "boolean";
                break;
            }
            case -6: {
                result = "tinyint";
                break;
            }
            case 5: {
                result = "smallint";
                break;
            }
            case 4: {
                result = "integer";
                break;
            }
            case -5: {
                result = "bigint";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                result = "double";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                result = "byte";
                break;
            }
            case 91: {
                result = "date";
                break;
            }
            case 92: {
                result = "time";
                break;
            }
            case 93: {
                result = "timestamp";
                break;
            }
        }
        return result;
    }

    public static boolean isPrecisionApplicable(String typeName) {
        return SqlUtil.isScaleApplicable(typeName) || DataType.STRING_FAMILY.contains(typeName);
    }

    public static boolean isScaleApplicable(String typeName) {
        return typeName.equals("decimal") || typeName.equals("numeric");
    }
}

