/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.util.PositionedCursor;

public abstract class IteratorCursor<E>
extends PositionedCursor<E> {
    private Position position = Position.BEFORE_START;
    private final Iterator<E> iterator;
    private E current = null;

    protected IteratorCursor(Iterator<E> iterator) {
        this.iterator = iterator;
    }

    @Override
    public boolean next() {
        if (this.iterator.hasNext()) {
            this.current = this.iterator.next();
            this.position = Position.OK;
            return true;
        }
        this.current = null;
        this.position = Position.AFTER_END;
        return false;
    }

    @Override
    public void close() {
        this.current = null;
        this.position = Position.CLOSED;
        if (this.iterator instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)this.iterator)).close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected E current() {
        if (this.position != Position.OK) {
            throw new NoSuchElementException();
        }
        return this.current;
    }

    private static enum Position {
        CLOSED,
        BEFORE_START,
        OK,
        AFTER_END;

    }
}

