/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.lock.DistributedLock;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.CubeJobLockUtil;
import org.apache.kylin.engine.mr.common.HadoopCmdOutput;
import org.apache.kylin.engine.mr.common.HadoopJobStatusChecker;
import org.apache.kylin.engine.mr.exception.MapReduceException;
import org.apache.kylin.job.constant.JobStepStatusEnum;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.execution.Output;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapReduceExecutable
extends AbstractExecutable {
    public static final String MAP_REDUCE_WAIT_TIME = "mapReduceWaitTime";
    private static final String KEY_MR_JOB = "MR_JOB_CLASS";
    private static final String KEY_PARAMS = "MR_JOB_PARAMS";
    private static final String KEY_COUNTER_SAVEAS = "MR_COUNTER_SAVEAS";
    private final Lock threadLock = new ReentrantLock();
    protected static final Logger logger = LoggerFactory.getLogger(MapReduceExecutable.class);
    private static final Option OPTION_JOB_CONF;
    private static final Option OPTION_CUBE_NAME;

    protected void onExecuteStart(ExecutableContext executableContext) {
        block7: {
            Output output = this.getOutput();
            if (output.getExtra().containsKey("startTime")) {
                String mrJobId = (String)output.getExtra().get("mr_job_id");
                if (mrJobId == null) {
                    this.getManager().updateJobOutput(this.getParam("project"), this.getId(), ExecutableState.RUNNING, null, null, this.getLogPath());
                    return;
                }
                try {
                    Configuration conf = new Configuration(HadoopUtil.getCurrentConfiguration());
                    this.overwriteJobConf(conf, executableContext.getConfig(), this.getMapReduceParams().trim().split("\\s+"));
                    Job job = new Cluster(conf).getJob(JobID.forName((String)mrJobId));
                    if (job == null || job.getJobState() == JobStatus.State.FAILED) {
                        super.onExecuteStart(executableContext);
                        break block7;
                    }
                    this.getManager().updateJobOutput(this.getParam("project"), this.getId(), ExecutableState.RUNNING, null, null, this.getLogPath());
                }
                catch (IOException | ParseException e) {
                    logger.warn("error get hadoop status");
                    super.onExecuteStart(executableContext);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn("error get hadoop status");
                    super.onExecuteStart(executableContext);
                }
            } else {
                super.onExecuteStart(executableContext);
            }
        }
    }

    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        String mapReduceJobClass = this.getMapReduceJobClass();
        DistributedLock lock = null;
        Preconditions.checkNotNull((Object)mapReduceJobClass);
        try {
            Job job;
            if (this.getIsNeedLock()) {
                lock = KylinConfig.getInstanceFromEnv().getDistributedLockFactory().lockForCurrentThread();
                this.getLock(lock);
            }
            ExecutableManager mgr = this.getManager();
            Configuration conf = new Configuration(HadoopUtil.getCurrentConfiguration());
            String[] jobArgs = this.overwriteJobConf(conf, context.getConfig(), this.getMapReduceParams().trim().split("\\s+"));
            Map extra = mgr.getOutput(this.getId()).getExtra();
            if (extra.containsKey("mr_job_id")) {
                job = new Cluster(conf).getJob(JobID.forName((String)((String)extra.get("mr_job_id"))));
                logger.info("mr_job_id:" + (String)extra.get("mr_job_id") + " resumed");
            } else {
                Constructor constructor = ClassUtil.forName((String)mapReduceJobClass, AbstractHadoopJob.class).getConstructor(new Class[0]);
                AbstractHadoopJob hadoopJob = (AbstractHadoopJob)((Object)constructor.newInstance(new Object[0]));
                hadoopJob.setConf(conf);
                hadoopJob.setAsync(true);
                logger.info("parameters of the MapReduceExecutable: {}", (Object)this.getMapReduceParams());
                try {
                    hadoopJob.run(jobArgs);
                    if (hadoopJob.isSkipped()) {
                        if (this.isDiscarded()) {
                            if (this.getIsNeedLock()) {
                                this.releaseLock(lock);
                            }
                            return new ExecuteResult(ExecuteResult.State.DISCARDED, "skipped");
                        }
                        return new ExecuteResult(ExecuteResult.State.SUCCEED, "skipped");
                    }
                }
                catch (Exception ex) {
                    StringBuilder log = new StringBuilder();
                    logger.error("error execute " + this.toString(), (Throwable)ex);
                    StringWriter stringWriter = new StringWriter();
                    ex.printStackTrace(new PrintWriter(stringWriter));
                    log.append(stringWriter.toString()).append("\n");
                    log.append("result code:").append(2);
                    if (this.isDiscarded()) {
                        if (this.getIsNeedLock()) {
                            this.releaseLock(lock);
                        }
                        return new ExecuteResult(ExecuteResult.State.DISCARDED, log.toString());
                    }
                    return new ExecuteResult(ExecuteResult.State.ERROR, log.toString(), (Throwable)ex);
                }
                job = hadoopJob.getJob();
            }
            StringBuilder output = new StringBuilder();
            HadoopCmdOutput hadoopCmdOutput = new HadoopCmdOutput(job, output);
            JobStepStatusEnum status = JobStepStatusEnum.NEW;
            while (!this.isDiscarded() && !this.isPaused()) {
                JobStepStatusEnum newStatus = HadoopJobStatusChecker.checkStatus(job, output);
                if (status == JobStepStatusEnum.KILLED) {
                    mgr.updateJobOutput(this.getParam("project"), this.getId(), ExecutableState.ERROR, hadoopCmdOutput.getInfo(), "killed by admin", null);
                    if (this.isDiscarded()) {
                        if (this.getIsNeedLock()) {
                            this.releaseLock(lock);
                        }
                        return new ExecuteResult(ExecuteResult.State.DISCARDED, "killed by admin");
                    }
                    return new ExecuteResult(ExecuteResult.State.FAILED, "killed by admin");
                }
                if (status == JobStepStatusEnum.WAITING && (newStatus == JobStepStatusEnum.FINISHED || newStatus == JobStepStatusEnum.ERROR || newStatus == JobStepStatusEnum.RUNNING)) {
                    long waitTime = System.currentTimeMillis() - this.getStartTime();
                    this.setMapReduceWaitTime(waitTime);
                }
                mgr.addJobInfo(this.getId(), hadoopCmdOutput.getInfo());
                status = newStatus;
                if (status.isComplete()) {
                    Map<String, String> info = hadoopCmdOutput.getInfo();
                    this.readCounters(hadoopCmdOutput, info);
                    mgr.addJobInfo(this.getId(), info);
                    if (status == JobStepStatusEnum.FINISHED) {
                        if (this.isDiscarded()) {
                            if (this.getIsNeedLock()) {
                                this.releaseLock(lock);
                            }
                            return new ExecuteResult(ExecuteResult.State.DISCARDED, output.toString());
                        }
                        return new ExecuteResult(ExecuteResult.State.SUCCEED, output.toString());
                    }
                    if (this.isDiscarded()) {
                        if (this.getIsNeedLock()) {
                            this.releaseLock(lock);
                        }
                        return new ExecuteResult(ExecuteResult.State.DISCARDED, output.toString());
                    }
                    return ExecuteResult.createFailed((Throwable)new MapReduceException(output.toString()));
                }
                Thread.sleep((long)context.getConfig().getYarnStatusCheckIntervalSeconds() * 1000L);
            }
            if (job != null) {
                try {
                    job.killJob();
                }
                catch (Exception e) {
                    logger.warn("failed to kill hadoop job: " + job.getJobID(), (Throwable)e);
                }
            }
            if (this.isDiscarded()) {
                if (this.getIsNeedLock()) {
                    this.releaseLock(lock);
                }
                return new ExecuteResult(ExecuteResult.State.DISCARDED, output.toString());
            }
            return new ExecuteResult(ExecuteResult.State.STOPPED, output.toString());
        }
        catch (ReflectiveOperationException e) {
            logger.error("error getMapReduceJobClass, class name:" + this.getParam(KEY_MR_JOB), (Throwable)e);
            if (this.isDiscarded()) {
                if (this.getIsNeedLock()) {
                    this.releaseLock(lock);
                }
                return new ExecuteResult(ExecuteResult.State.DISCARDED, e.getMessage());
            }
            return ExecuteResult.createError((Throwable)e);
        }
        catch (Exception e) {
            logger.error("error execute " + this.toString(), (Throwable)e);
            if (this.isDiscarded()) {
                if (this.getIsNeedLock()) {
                    this.releaseLock(lock);
                }
                return new ExecuteResult(ExecuteResult.State.DISCARDED, e.getMessage());
            }
            return ExecuteResult.createError((Throwable)e);
        }
    }

    private void readCounters(HadoopCmdOutput hadoopCmdOutput, Map<String, String> info) {
        hadoopCmdOutput.updateJobCounter();
        info.put("source_records_count", hadoopCmdOutput.getMapInputRecords());
        info.put("source_records_size", hadoopCmdOutput.getRawInputBytesRead());
        info.put("hdfs_bytes_written", hadoopCmdOutput.getHdfsBytesWritten());
        String saveAs = this.getParam(KEY_COUNTER_SAVEAS);
        if (saveAs != null) {
            String[] saveAsNames = saveAs.split(",");
            this.saveCounterAs(hadoopCmdOutput.getMapInputRecords(), saveAsNames, 0, info);
            this.saveCounterAs(hadoopCmdOutput.getRawInputBytesRead(), saveAsNames, 1, info);
            this.saveCounterAs(hadoopCmdOutput.getHdfsBytesWritten(), saveAsNames, 2, info);
        }
    }

    private void saveCounterAs(String counter, String[] saveAsNames, int i, Map<String, String> info) {
        if (saveAsNames.length > i && !StringUtils.isBlank((String)saveAsNames[i])) {
            info.put(saveAsNames[i].trim(), counter);
        }
    }

    public long getMapReduceWaitTime() {
        return this.getExtraInfoAsLong(MAP_REDUCE_WAIT_TIME, 0L);
    }

    public void setMapReduceWaitTime(long t) {
        this.addExtraInfo(MAP_REDUCE_WAIT_TIME, t + "");
    }

    public String getMapReduceJobClass() throws ExecuteException {
        return this.getParam(KEY_MR_JOB);
    }

    public void setMapReduceJobClass(Class<? extends AbstractHadoopJob> clazzName) {
        this.setParam(KEY_MR_JOB, clazzName.getName());
    }

    public String getMapReduceParams() {
        return this.getParam(KEY_PARAMS);
    }

    public void setMapReduceParams(String param) {
        this.setParam(KEY_PARAMS, param);
    }

    public void setCounterSaveAs(String value) {
        this.setParam(KEY_COUNTER_SAVEAS, value);
    }

    public void setIsNeedLock(Boolean isNeedLock) {
        this.setParam("isNeedLock", String.valueOf(isNeedLock));
    }

    public boolean getIsNeedLock() {
        String isNeedLock = this.getParam("isNeedLock");
        return Strings.isNullOrEmpty((String)isNeedLock) ? false : Boolean.parseBoolean(isNeedLock);
    }

    public void setIsNeedReleaseLock(Boolean isNeedReleaseLock) {
        this.setParam("isNeedReleaseLock", String.valueOf(isNeedReleaseLock));
    }

    public boolean getIsNeedReleaseLock() {
        String isNeedReleaseLock = this.getParam("isNeedReleaseLock");
        return Strings.isNullOrEmpty((String)isNeedReleaseLock) ? false : Boolean.parseBoolean(isNeedReleaseLock);
    }

    public void setLockPathName(String pathName) {
        this.setParam("lockPathName", pathName);
    }

    public String getLockPathName() {
        return this.getParam("lockPathName");
    }

    public void setJobFlowJobId(String jobId) {
        this.setParam("jobFlowJobId", jobId);
    }

    public String getJobFlowJobId() {
        return this.getParam("jobFlowJobId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLock(DistributedLock lock) throws InterruptedException {
        long lockStartTime;
        String fullLockPath;
        block13: {
            logger.info("{} try to get zk lock, zk client {} ", (Object)this.getId(), (Object)lock.getClient());
            String ephemeralLockPath = this.getEphemeralLockPathName();
            fullLockPath = this.getCubeJobLockPathName();
            boolean isLockedByOther = true;
            boolean getLocked = false;
            lockStartTime = System.currentTimeMillis();
            boolean isLockedByTheJob = lock.isLocked(fullLockPath);
            logger.info("cube job {} zk lock is isLockedByTheJob:{}", (Object)this.getId(), (Object)isLockedByTheJob);
            if (!isLockedByTheJob) {
                while (isLockedByOther) {
                    isLockedByOther = lock.isLocked(this.getCubeJobLockParentPathName());
                    if (!isLockedByOther) {
                        isLockedByOther = lock.isLocked(ephemeralLockPath);
                        logger.info("zookeeper lock path :{}, is locked by other job result is {}", (Object)ephemeralLockPath, (Object)isLockedByOther);
                        if (!isLockedByOther) {
                            block14: {
                                try {
                                    logger.debug("{} before start to get lock ephemeralLockPath {}", (Object)this.getId(), (Object)ephemeralLockPath);
                                    this.threadLock.lock();
                                    logger.debug("{} start to get lock ephemeralLockPath {}", (Object)this.getId(), (Object)ephemeralLockPath);
                                    getLocked = lock.lock(ephemeralLockPath);
                                    logger.debug("{} finish get lock ephemeralLockPath {},getLocked {}", new Object[]{this.getId(), ephemeralLockPath, getLocked});
                                }
                                finally {
                                    this.threadLock.unlock();
                                    logger.debug("{} finish unlock the thread lock ,ephemeralLockPath {} ", (Object)this.getId(), (Object)ephemeralLockPath);
                                }
                                if (getLocked) {
                                    try {
                                        getLocked = lock.globalPermanentLock(fullLockPath);
                                        if (getLocked) break block13;
                                        if (lock.isLocked(ephemeralLockPath)) {
                                            lock.unlock(ephemeralLockPath);
                                        }
                                    }
                                    catch (Exception e) {
                                        if (!lock.isLocked(ephemeralLockPath)) break block14;
                                        lock.unlock(ephemeralLockPath);
                                    }
                                }
                            }
                            isLockedByOther = true;
                        }
                    }
                    logger.info("{}, parent lock path({}) is locked by other job result is {} ,ephemeral lock path :{} is locked by other job result is {},will try after one minute", new Object[]{this.getId(), this.getCubeJobLockParentPathName(), isLockedByOther, ephemeralLockPath, isLockedByOther});
                    Thread.sleep(60000L);
                }
            } else {
                lock.lock(ephemeralLockPath);
            }
        }
        long useSec = (System.currentTimeMillis() - lockStartTime) / 1000L;
        logger.info("job {} get zookeeper lock path:{} success,zookeeper get lock costTime : {} s", new Object[]{this.getId(), fullLockPath, useSec});
    }

    private void releaseLock(DistributedLock lock) {
        String parentLockPath = this.getCubeJobLockParentPathName();
        String ephemeralLockPath = this.getEphemeralLockPathName();
        if (lock.isLocked(this.getCubeJobLockPathName())) {
            lock.purgeLocks(parentLockPath);
            logger.info("{} unlock cube job dict lock path({}) success", (Object)this.getJobFlowJobId(), (Object)parentLockPath);
            if (lock.isLocked(ephemeralLockPath)) {
                lock.purgeLocks(ephemeralLockPath);
                logger.info("{} unlock cube job ephemeral lock path({}) success", (Object)this.getJobFlowJobId(), (Object)ephemeralLockPath);
            }
        }
    }

    private String getEphemeralLockPathName() {
        String pathName = this.getLockPathName();
        if (Strings.isNullOrEmpty((String)pathName)) {
            throw new IllegalArgumentException("cube job lock path name is null");
        }
        return CubeJobLockUtil.getEphemeralLockPath(pathName);
    }

    private String getCubeJobLockPathName() {
        String pathName = this.getLockPathName();
        if (Strings.isNullOrEmpty((String)pathName)) {
            throw new IllegalArgumentException("cube job lock path name is null");
        }
        String flowJobId = this.getJobFlowJobId();
        if (Strings.isNullOrEmpty((String)flowJobId)) {
            throw new IllegalArgumentException("cube job lock path flowJobId is null");
        }
        return CubeJobLockUtil.getLockPath(pathName, flowJobId);
    }

    private String getCubeJobLockParentPathName() {
        String pathName = this.getLockPathName();
        if (Strings.isNullOrEmpty((String)pathName)) {
            throw new IllegalArgumentException(" create mr hive dict lock path name is null");
        }
        return CubeJobLockUtil.getLockPath(pathName, null);
    }

    private String[] overwriteJobConf(Configuration conf, KylinConfig config, String[] jobParams) throws ParseException {
        Options options = new Options();
        options.addOption(OPTION_JOB_CONF);
        options.addOption(OPTION_CUBE_NAME);
        CustomParser parser = new CustomParser();
        CommandLine commandLine = parser.parse(options, jobParams);
        String confFile = commandLine.getOptionValue("conf");
        String cubeName = commandLine.getOptionValue("cubename");
        ArrayList remainingArgs = Lists.newArrayList();
        if (StringUtils.isNotBlank((String)confFile)) {
            conf.addResource(new Path(confFile));
        }
        KylinConfig configOverride = cubeName != null ? CubeManager.getInstance((KylinConfig)config).getCube(cubeName).getConfig() : config;
        for (Map.Entry entry : configOverride.getMRConfigOverride().entrySet()) {
            conf.set((String)entry.getKey(), (String)entry.getValue());
        }
        if (conf.get("mapreduce.job.is-mem-hungry") != null && Boolean.parseBoolean(conf.get("mapreduce.job.is-mem-hungry"))) {
            for (Map.Entry entry : configOverride.getMemHungryConfigOverride().entrySet()) {
                conf.set((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (StringUtils.isNotBlank((String)cubeName)) {
            remainingArgs.add("-cubename");
            remainingArgs.add(cubeName);
        }
        remainingArgs.addAll(parser.getRemainingArgs());
        return remainingArgs.toArray(new String[remainingArgs.size()]);
    }

    static {
        OptionBuilder.withArgName((String)"conf");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OPTION_JOB_CONF = OptionBuilder.create((String)"conf");
        OptionBuilder.withArgName((String)"cubename");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OPTION_CUBE_NAME = OptionBuilder.create((String)"cubename");
    }

    private static class CustomParser
    extends GnuParser {
        private List<String> remainingArgs = Lists.newArrayList();

        protected void processOption(String arg, ListIterator iter) throws ParseException {
            boolean hasOption = this.getOptions().hasOption(arg);
            if (hasOption) {
                super.processOption(arg, iter);
            } else {
                this.remainingArgs.add(arg);
                this.remainingArgs.add(iter.next().toString());
            }
        }

        public List<String> getRemainingArgs() {
            return this.remainingArgs;
        }
    }
}

