/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.persistence.AutoDeleteDirectory;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.ResourceTool;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.source.SourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRelatedMetaUtil {
    private static final Logger logger = LoggerFactory.getLogger(JobRelatedMetaUtil.class);

    private JobRelatedMetaUtil() {
    }

    public static Set<String> collectCubeMetadata(CubeInstance cube) {
        LinkedHashSet<String> dumpList = new LinkedHashSet<String>();
        dumpList.add(cube.getResourcePath());
        dumpList.add(cube.getDescriptor().getModel().getResourcePath());
        dumpList.add(cube.getDescriptor().getResourcePath());
        dumpList.add(cube.getProjectInstance().getResourcePath());
        for (TableRef tableRef : cube.getDescriptor().getModel().getAllTables()) {
            TableDesc table = tableRef.getTableDesc();
            dumpList.add(table.getResourcePath());
            dumpList.addAll(SourceManager.getMRDependentResources((TableDesc)table));
        }
        return dumpList;
    }

    public static void dumpResources(KylinConfig kylinConfig, File metaDir, Set<String> dumpList) throws IOException {
        long startTime = System.currentTimeMillis();
        ResourceStore from = ResourceStore.getStore((KylinConfig)kylinConfig);
        KylinConfig localConfig = KylinConfig.createInstanceFromUri((String)metaDir.getAbsolutePath());
        ResourceStore to = ResourceStore.getStore((KylinConfig)localConfig);
        for (String path : dumpList) {
            RawResource res = from.getResource(path);
            if (res == null) {
                throw new IllegalStateException("No resource found at -- " + path);
            }
            to.putResource(path, res.content(), res.lastModified());
            res.content().close();
        }
        logger.debug("Dump resources to {} took {} ms", (Object)metaDir, (Object)(System.currentTimeMillis() - startTime));
    }

    public static void dumpAndUploadKylinPropsAndMetadata(Set<String> dumpList, KylinConfigExt kylinConfig, String metadataUrl) throws IOException {
        try (AutoDeleteDirectory tmpDir = new AutoDeleteDirectory("kylin_job_meta", "");
             AutoDeleteDirectory metaDir = tmpDir.child("meta");){
            JobRelatedMetaUtil.dumpResources((KylinConfig)kylinConfig, metaDir.getFile(), dumpList);
            JobRelatedMetaUtil.dumpResources((KylinConfig)kylinConfig, metaDir.getFile(), dumpList);
            Properties props = kylinConfig.exportToProperties();
            props.setProperty("kylin.metadata.url", metadataUrl);
            File kylinPropsFile = new File(metaDir.getFile(), "kylin.properties");
            try (FileOutputStream os = new FileOutputStream(kylinPropsFile);){
                props.store(os, kylinPropsFile.getAbsolutePath());
            }
            KylinConfig dstConfig = KylinConfig.createKylinConfig((Properties)props);
            new ResourceTool().copy(KylinConfig.createInstanceFromUri((String)metaDir.getAbsolutePath()), dstConfig);
        }
    }
}

